/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import org.jmol.modelset.Atom;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;
import org.jmol.util.P3;

class QMAtom
extends P3 {
    private float[] myX;
    private float[] myY;
    private float[] myZ;
    private float[] myX2;
    private float[] myY2;
    private float[] myZ2;
    Atom atom;
    int index;
    int znuc;
    int iMolecule;

    QMAtom(int n, Atom atom, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float f) {
        this.index = n;
        this.myX = fArray;
        this.myY = fArray2;
        this.myZ = fArray3;
        this.myX2 = fArray4;
        this.myY2 = fArray5;
        this.myZ2 = fArray6;
        this.atom = atom;
        this.setT(atom);
        this.scale(f);
        this.znuc = atom.getElementNumber();
    }

    protected void setXYZ(QuantumCalculation quantumCalculation, boolean bl) {
        try {
            int n;
            if (bl) {
                if (quantumCalculation.points != null) {
                    quantumCalculation.zMin = 0;
                    quantumCalculation.yMin = 0;
                    quantumCalculation.xMin = 0;
                    quantumCalculation.yMax = quantumCalculation.zMax = quantumCalculation.points.length;
                    quantumCalculation.xMax = quantumCalculation.zMax;
                } else {
                    n = (int)Math.floor((this.x - quantumCalculation.xBohr[0] - quantumCalculation.rangeBohrOrAngstroms) / quantumCalculation.stepBohr[0]);
                    quantumCalculation.xMin = n < 0 ? 0 : n;
                    n = (int)Math.floor(1.0f + (this.x - quantumCalculation.xBohr[0] + quantumCalculation.rangeBohrOrAngstroms) / quantumCalculation.stepBohr[0]);
                    quantumCalculation.xMax = n >= quantumCalculation.nX ? quantumCalculation.nX : n + 1;
                    n = (int)Math.floor((this.y - quantumCalculation.yBohr[0] - quantumCalculation.rangeBohrOrAngstroms) / quantumCalculation.stepBohr[1]);
                    quantumCalculation.yMin = n < 0 ? 0 : n;
                    n = (int)Math.floor(1.0f + (this.y - quantumCalculation.yBohr[0] + quantumCalculation.rangeBohrOrAngstroms) / quantumCalculation.stepBohr[1]);
                    quantumCalculation.yMax = n >= quantumCalculation.nY ? quantumCalculation.nY : n + 1;
                    n = (int)Math.floor((this.z - quantumCalculation.zBohr[0] - quantumCalculation.rangeBohrOrAngstroms) / quantumCalculation.stepBohr[2]);
                    quantumCalculation.zMin = n < 0 ? 0 : n;
                    n = (int)Math.floor(1.0f + (this.z - quantumCalculation.zBohr[0] + quantumCalculation.rangeBohrOrAngstroms) / quantumCalculation.stepBohr[2]);
                    quantumCalculation.zMax = n >= quantumCalculation.nZ ? quantumCalculation.nZ : n + 1;
                }
            }
            n = quantumCalculation.xMax;
            while (--n >= quantumCalculation.xMin) {
                this.myX2[n] = this.myX[n] = quantumCalculation.xBohr[n] - this.x;
                int n2 = n;
                this.myX2[n2] = this.myX2[n2] * this.myX[n];
            }
            n = quantumCalculation.yMax;
            while (--n >= quantumCalculation.yMin) {
                this.myY2[n] = this.myY[n] = quantumCalculation.yBohr[n] - this.y;
                int n3 = n;
                this.myY2[n3] = this.myY2[n3] * this.myY[n];
            }
            n = quantumCalculation.zMax;
            while (--n >= quantumCalculation.zMin) {
                this.myZ2[n] = this.myZ[n] = quantumCalculation.zBohr[n] - this.z;
                int n4 = n;
                this.myZ2[n4] = this.myZ2[n4] * this.myZ[n];
            }
            if (quantumCalculation.points != null) {
                quantumCalculation.zMax = 1;
                quantumCalculation.yMax = 1;
            }
        }
        catch (Exception exception) {
            Logger.error("Error in QuantumCalculation setting bounds");
        }
    }
}

