/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolList;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected final Atom[] closest = new Atom[1];
    private SymmetryInterface pointGroup;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Matrix4f mat4 = new Matrix4f();
    private final Matrix4f mat4t = new Matrix4f();
    private final V3 vTemp = new V3();

    public ModelSet(Viewer viewer, String string) {
        this.viewer = viewer;
        this.modelSetName = string;
    }

    @Override
    protected void releaseModelSet() {
        this.models = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        this.selectionHaloEnabled = bl;
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.modelNumbers[i] != n && (n >= 1000000 || this.modelNumbers[i] != 1000000 + n)) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public BS getBitSetTrajectories() {
        if (this.trajectorySteps == null) {
            return null;
        }
        BS bS = new BS();
        int n = this.modelCount;
        while (--n >= 0) {
            int n2 = this.models[n].getSelectedTrajectory();
            if (n2 < 0) continue;
            bS.set(n2);
            n = this.models[n].trajectoryBaseIndex;
        }
        return bS;
    }

    public void setTrajectoryBs(BS bS) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bS.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int n) {
        if (n < 0 || !this.isTrajectory(n)) {
            return;
        }
        if (this.atoms[this.models[n].firstAtomIndex].modelIndex == n) {
            return;
        }
        int n2 = this.models[n].trajectoryBaseIndex;
        this.models[n2].setSelectedTrajectory(n);
        this.setAtomPositions(n2, n, (P3[])this.trajectorySteps.get(n), null, 0.0f, this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(n), true);
        int n3 = this.viewer.getCurrentModelIndex();
        if (n3 >= 0 && n3 != n && this.models[n3].fileIndex == this.models[n].fileIndex) {
            this.viewer.setCurrentModelIndexClear(n, false);
        }
    }

    public void morphTrajectories(int n, int n2, float f) {
        if (n < 0 || n2 < 0 || !this.isTrajectory(n) || !this.isTrajectory(n2)) {
            return;
        }
        if (f == 0.0f) {
            this.setTrajectory(n);
            return;
        }
        if (f == 1.0f) {
            this.setTrajectory(n2);
            return;
        }
        int n3 = this.models[n].trajectoryBaseIndex;
        this.models[n3].setSelectedTrajectory(n);
        this.setAtomPositions(n3, n, (P3[])this.trajectorySteps.get(n), (P3[])this.trajectorySteps.get(n2), f, this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(n), true);
        int n4 = this.viewer.getCurrentModelIndex();
        if (n4 >= 0 && n4 != n && this.models[n4].fileIndex == this.models[n].fileIndex) {
            this.viewer.setCurrentModelIndexClear(n, false);
        }
    }

    private void setAtomPositions(int n, int n2, P3[] p3Array, P3[] p3Array2, float f, V3[] v3Array, boolean bl) {
        BS bS = new BS();
        V3 v3 = new V3();
        int n3 = this.models[n].firstAtomIndex;
        int n4 = n3 + this.getAtomCountInModel(n);
        if (f == 0.0f) {
            int n5 = 0;
            for (int i = n3; i < n4 && n5 < p3Array.length; ++i, ++n5) {
                this.atoms[i].modelIndex = (short)n2;
                if (p3Array[n5] == null) continue;
                if (bl) {
                    this.atoms[i].setFractionalCoordTo(p3Array[n5], true);
                } else {
                    this.atoms[i].setT(p3Array[n5]);
                }
                if (this.vibrationSteps != null) {
                    if (v3Array != null && v3Array[n5] != null) {
                        v3 = v3Array[n5];
                    }
                    this.setVibrationVector(i, v3.x, v3.y, v3.z);
                }
                bS.set(i);
            }
        } else {
            P3 p3 = new P3();
            int n6 = Math.min(p3Array.length, p3Array2.length);
            int n7 = 0;
            for (int i = n3; i < n4 && n7 < n6; ++i, ++n7) {
                this.atoms[i].modelIndex = (short)n2;
                if (p3Array[n7] == null || p3Array2[n7] == null) continue;
                p3.sub2(p3Array2[n7], p3Array[n7]);
                p3.scaleAdd2(f, p3, p3Array[n7]);
                if (bl) {
                    this.atoms[i].setFractionalCoordTo(p3, true);
                } else {
                    this.atoms[i].setT(p3);
                }
                bS.set(i);
            }
        }
        this.initializeBspf();
        this.validateBspfForModel(n, false);
        this.recalculateLeadMidpointsAndWingVectors(n);
        this.shapeManager.refreshShapeTrajectories(n, bS, null);
        if (this.models[n].hasRasmolHBonds) {
            this.models[n].clearRasmolHydrogenBonds(null);
            this.models[n].getRasmolHydrogenBonds(bS, bS, null, false, Integer.MAX_VALUE, false, null);
        }
    }

    public P3[] getFrameOffsets(BS bS) {
        int n;
        if (bS == null) {
            return null;
        }
        P3[] p3Array = new P3[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            p3Array[n] = new P3();
        }
        n = 0;
        int n2 = 0;
        P3 p3 = p3Array[0];
        boolean bl = this.trajectorySteps != null && this.trajectorySteps.size() == this.modelCount;
        int n3 = bl ? this.modelCount : 1;
        block1: for (int i = 0; i < n3; ++i) {
            if (bl) {
                this.setTrajectory(i);
            }
            for (int j = 0; j <= this.atomCount; ++j) {
                if (j == this.atomCount || this.atoms[j].modelIndex != n) {
                    if (n2 > 0) {
                        p3.scale(-1.0f / (float)n2);
                        if (n != 0) {
                            p3.sub(p3Array[0]);
                        }
                        n2 = 0;
                    }
                    if (j == this.atomCount) continue block1;
                    n = this.atoms[j].modelIndex;
                    p3 = p3Array[n];
                }
                if (!bS.get(j)) continue;
                p3.add(this.atoms[j]);
                ++n2;
            }
        }
        p3Array[0].set(0.0f, 0.0f, 0.0f);
        return p3Array;
    }

    public BS getAtomBits(int n, Object object) {
        switch (n) {
            case 0x100022: {
                int n2 = (Integer)object;
                int n3 = this.getModelNumberIndex(n2, true, true);
                return n3 < 0 && n2 > 0 ? new BS() : this.viewer.getModelUndeletedAtomsBitSet(n3);
            }
        }
        return BSUtil.andNot(this.getAtomBitsMaybeDeleted(n, object), this.viewer.getDeletedAtoms());
    }

    public String getAtomLabel(int n) {
        return (String)this.viewer.getShapePropertyIndex(5, "label", n);
    }

    public int findNearestAtomIndex(int n, int n2, BS bS, int n3) {
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearest2(n, n2, this.closest, bS, n3);
        this.shapeManager.findNearestShapeAtomIndex(n, n2, this.closest, bS);
        int n4 = this.closest[0] == null ? -1 : this.closest[0].index;
        this.closest[0] = null;
        return n4;
    }

    public String calculateStructures(BS bS, boolean bl, boolean bl2, boolean bl3) {
        BS bS2 = new BS();
        BS bS3 = BSUtil.copyInvert(this.modelsOf(bS, bS2), this.modelCount);
        if (!bl3) {
            return this.calculateStructuresAllExcept(bS3, bl, true, bl2, false, false);
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (bS3.get(i)) continue;
            this.models[i].clearBioPolymers();
        }
        this.calculatePolymers(null, 0, 0, bS3);
        String string = this.calculateStructuresAllExcept(bS3, bl, true, bl2, true, false);
        this.viewer.resetBioshapes(bS2);
        this.setStructureIndexes();
        return string;
    }

    public String calculatePointGroup(BS bS) {
        return (String)this.calculatePointGroupForFirstModel(bS, false, false, false, null, 0, 0.0f);
    }

    public Map<String, Object> getPointGroupInfo(BS bS) {
        return (Map)this.calculatePointGroupForFirstModel(bS, false, false, true, null, 0, 0.0f);
    }

    public String getPointGroupAsString(BS bS, boolean bl, String string, int n, float f) {
        return (String)this.calculatePointGroupForFirstModel(bS, true, bl, false, string, n, f);
    }

    private Object calculatePointGroupForFirstModel(BS bS, boolean bl, boolean bl2, boolean bl3, String string, int n, float f) {
        Object object;
        int n2;
        int n3 = this.viewer.getCurrentModelIndex();
        int n4 = n2 = bS == null ? -1 : bS.nextSetBit(0);
        if (n3 < 0 && n2 >= 0) {
            n3 = this.atoms[n2].getModelIndex();
        }
        if (n3 < 0) {
            n3 = this.viewer.getVisibleFramesBitSet().nextSetBit(0);
            bS = null;
        }
        BS bS2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
        if (bS != null) {
            bS2.and(bS);
        }
        if ((n2 = bS2.nextSetBit(0)) < 0) {
            bS2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
            n2 = bS2.nextSetBit(0);
        }
        boolean bl4 = (object = this.viewer.getShapePropertyIndex(18, "mad", n2)) != null && (Integer)object != 0 || this.viewer.isVibrationOn();
        SymmetryInterface symmetryInterface = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        this.pointGroup = symmetryInterface.setPointGroup(this.pointGroup, this.atoms, bS2, bl4, this.viewer.getFloat(0x22000026), this.viewer.getFloat(0x22000028));
        if (!bl && !bl3) {
            return this.pointGroup.getPointGroupName();
        }
        Object object2 = this.pointGroup.getPointGroupInfo(n3, bl2, bl3, string, n, f);
        if (bl3) {
            return object2;
        }
        return (this.modelCount > 1 ? "frame " + this.getModelNumberDotted(n3) + "; " : "") + object2;
    }

    private BS modelsOf(BS bS, BS bS2) {
        int n;
        BS bS3 = BSUtil.newBitSet(this.modelCount);
        boolean bl = bS == null;
        int n2 = n = bl ? this.atomCount - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.models[this.atoms[n2].modelIndex].trajectoryBaseIndex;
            if (!this.isJmolDataFrameForModel(n3)) {
                bS3.set(n3);
                bS2.set(n2);
            }
            n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        return bS3;
    }

    public String getDefaultStructure(BS bS, BS bS2) {
        BS bS3 = this.modelsOf(bS, bS2);
        SB sB = new SB();
        int n = bS3.nextSetBit(0);
        while (n >= 0) {
            if (this.models[n].isBioModel && this.models[n].defaultStructure != null) {
                sB.append(this.models[n].defaultStructure);
            }
            n = bS3.nextSetBit(n + 1);
        }
        return sB.toString();
    }

    public int[] makeConnections(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        if (n2 == 1073741852 && n != 2048) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            this.addStateScript(string, bl ? bS : null, bl ? null : bS, bl ? null : bS2, " auto", false, true);
        }
        this.moleculeCount = 0;
        return this.makeConnections2(f, f2, n, n2, bS, bS2, bS3, bl, bl2, f3);
    }

    public void setPdbConectBonding(int n, int n2, BS bS) {
        short s = this.viewer.getMadBond();
        for (int i = n2; i < this.modelCount; ++i) {
            int n3;
            JmolList jmolList = (JmolList)this.getModelAuxiliaryInfoValue(i, "PDB_CONECT_bonds");
            if (jmolList == null) continue;
            int n4 = jmolList.size();
            this.setModelAuxiliaryInfo(i, "initialBondCount", n4);
            int[] nArray = (int[])this.getModelAuxiliaryInfoValue(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])jmolList.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                if (bS != null) {
                    if (this.atoms[n11].isHetero()) {
                        bS.set(n11);
                    }
                    if (this.atoms[n12].isHetero()) {
                        bS.set(n12);
                    }
                }
                this.checkValencesAndBond(this.atoms[n11], this.atoms[n12], s2, s2 == 2048 ? (short)1 : s, null);
            }
        }
    }

    public void deleteAllBonds() {
        this.moleculeCount = 0;
        int n = this.stateScripts.size();
        while (--n >= 0) {
            if (!((ModelCollection.StateScript)this.stateScripts.get(n)).isConnect()) continue;
            this.stateScripts.remove(n);
        }
        this.deleteAllBonds2();
    }

    private void includeAllRelatedFrames(BS bS) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (bS.get(i)) {
                int n;
                if (!this.isTrajectory(i) || bS.get(n = this.models[i].trajectoryBaseIndex)) continue;
                bS.set(n);
                this.includeAllRelatedFrames(bS);
                return;
            }
            if ((!this.isTrajectory(i) || !bS.get(this.models[i].trajectoryBaseIndex)) && (!this.isJmolDataFrameForModel(i) || !bS.get(this.models[i].dataSourceFrame))) continue;
            bS.set(i);
        }
    }

    public BS deleteModels(BS bS) {
        int n;
        this.moleculeCount = 0;
        BS bS2 = this.getModelBitSet(bS, false);
        this.includeAllRelatedFrames(bS2);
        int n2 = 0;
        int n3 = BSUtil.cardinalityOf(bS2);
        if (n3 == 0) {
            return null;
        }
        int n4 = bS2.nextSetBit(0);
        while (n4 >= 0) {
            this.clearDataFrameReference(n4);
            n4 = bS2.nextSetBit(n4 + 1);
        }
        if (n3 == this.modelCount) {
            BS bS3 = this.getModelAtomBitSetIncludingDeleted(-1, true);
            this.viewer.zap(true, false, false);
            return bS3;
        }
        this.validateBspf(false);
        Model[] modelArray = new Model[this.modelCount - n3];
        Model[] modelArray2 = this.models;
        BS bS4 = new BS();
        int n5 = 0;
        for (n = 0; n < this.modelCount; ++n) {
            if (bS2.get(n)) {
                this.getAtomCountInModel(n);
                bS4.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                continue;
            }
            this.models[n].modelIndex = n5;
            modelArray[n5++] = this.models[n];
        }
        this.models = modelArray;
        n = this.modelCount;
        BS bS5 = this.getBondsForSelectedAtoms(bS4, true);
        this.deleteBonds(bS5, true);
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bS2.get(i)) {
                ++n6;
                continue;
            }
            int n7 = modelArray2[i].atomCount;
            if (n7 == 0) continue;
            n2 += n7;
            BS bS6 = modelArray2[i].bsAtoms;
            int n8 = modelArray2[i].firstAtomIndex;
            BSUtil.deleteBits(this.bsSymmetry, bS6);
            this.deleteModel(n6, n8, n7, bS6, bS5);
            int n9 = n;
            while (--n9 > i) {
                modelArray2[n9].fixIndices(n6, n7, bS6);
            }
            this.viewer.deleteShapeAtoms(new Object[]{modelArray, this.atoms, new int[]{n6, n8, n7}}, bS6);
            --this.modelCount;
        }
        this.deleteModel(-1, 0, 0, null, null);
        return bS4;
    }

    public void setAtomProperty(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                int n3;
                Object object;
                if (f > 4.0f) {
                    f = 4.0f;
                }
                if (fArray != null) {
                    object = new float[this.atomCount];
                    n3 = bS.nextSetBit(0);
                    int n4 = 0;
                    while (n3 >= 0) {
                        object[n3] = fArray[n4++];
                        n3 = bS.nextSetBit(n3 + 1);
                    }
                    fArray = object;
                }
            }
            case 1113200646: 
            case 1113200652: {
                Object object = null;
                int n3 = 0;
                if (fArray == null) {
                    if (f > 16.0f) {
                        f = 16.0f;
                    }
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    n3 = (int)Math.floor(f * 2000.0f);
                } else {
                    object = new RadiusData(fArray, 0.0f, null, null);
                }
                this.shapeManager.setShapeSizeBs(JC.shapeTokenIndex(n), n3, (RadiusData)object, bS);
                return;
            }
        }
        this.setAPm(bS, n, n2, f, string, fArray, stringArray);
    }

    public Object getFileData(int n) {
        if (n < 0) {
            return "";
        }
        Map<String, Object> map = (Map<String, Object>)this.getModelAuxiliaryInfoValue(n, "fileData");
        if (map != null) {
            return map;
        }
        if (!this.getModelAuxiliaryInfoBoolean(n, "isCIF")) {
            return this.getPDBHeader(n);
        }
        map = this.viewer.getCifData(n);
        this.setModelAuxiliaryInfo(n, "fileData", map);
        return map;
    }

    @Override
    public int calculateStruts(BS bS, BS bS2) {
        this.viewer.setModelVisibility();
        return super.calculateStruts(bS, bS2);
    }

    public BS addHydrogens(JmolList<Atom> jmolList, P3[] p3Array) {
        int n = this.modelCount - 1;
        BS bS = new BS();
        if (this.isTrajectory(n) || this.models[n].getGroupCount() > 1) {
            return bS;
        }
        this.growAtomArrays(this.atomCount + p3Array.length);
        RadiusData radiusData = this.viewer.getDefaultRadiusData();
        short s = this.getDefaultMadFromOrder(1);
        int n2 = 0;
        int n3 = this.models[n].atomCount + 1;
        while (n2 < jmolList.size()) {
            Atom atom = (Atom)jmolList.get(n2);
            Atom atom2 = this.addAtom(n, atom.group, (short)1, "H" + n3, n3, n3, p3Array[n2].x, p3Array[n2].y, p3Array[n2].z, Float.NaN, Float.NaN, Float.NaN, Float.NaN, 0, 0.0f, 100, Float.NaN, null, false, (byte)0, null);
            atom2.setMadAtom(this.viewer, radiusData);
            bS.set(atom2.index);
            this.bondAtoms(atom, atom2, 1, s, null, 0.0f, false, false);
            ++n2;
            ++n3;
        }
        this.shapeManager.loadDefaultShapes(this);
        return bS;
    }

    public void setAtomCoordsRelative(Tuple3f tuple3f, BS bS) {
        this.setAtomsCoordRelative(bS, tuple3f.x, tuple3f.y, tuple3f.z);
        this.mat4.setIdentity();
        this.vTemp.setT(tuple3f);
        this.mat4.setTranslation(this.vTemp);
        this.recalculatePositionDependentQuantities(bS, this.mat4);
    }

    public void setAtomCoords(BS bS, int n, Object object) {
        this.setAtomCoord2(bS, n, object);
        switch (n) {
            case 1112541202: 
            case 1112541203: 
            case 1112541204: 
            case 1146095631: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities(bS, null);
            }
        }
    }

    public void invertSelected(P3 p3, P4 p4, int n, BS bS, BS bS2) {
        if (p3 != null) {
            int n2 = bS2.nextSetBit(0);
            while (n2 >= 0) {
                float f = (p3.x - this.atoms[n2].x) * 2.0f;
                float f2 = (p3.y - this.atoms[n2].y) * 2.0f;
                float f3 = (p3.z - this.atoms[n2].z) * 2.0f;
                this.setAtomCoordRelative(n2, f, f2, f3);
                n2 = bS2.nextSetBit(n2 + 1);
            }
            return;
        }
        if (p4 != null) {
            V3 v3 = V3.new3(p4.x, p4.y, p4.z);
            v3.normalize();
            float f = (float)Math.sqrt(p4.x * p4.x + p4.y * p4.y + p4.z * p4.z);
            int n3 = bS2.nextSetBit(0);
            while (n3 >= 0) {
                float f4 = -Measure.distanceToPlaneD(p4, f, this.atoms[n3]) * 2.0f;
                float f5 = v3.x * f4;
                float f6 = v3.y * f4;
                float f7 = v3.z * f4;
                this.setAtomCoordRelative(n3, f5, f6, f7);
                n3 = bS2.nextSetBit(n3 + 1);
            }
            return;
        }
        if (n >= 0) {
            Object object;
            Atom atom = this.atoms[n];
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return;
            }
            BS bS3 = new BS();
            JmolList<P3> jmolList = new JmolList<P3>();
            BS bS4 = this.viewer.getModelUndeletedAtomsBitSet(atom.modelIndex);
            for (int i = 0; i < bondArray.length; ++i) {
                object = bondArray[i].getOtherAtom(atom);
                if (bS.get(((Atom)object).index)) {
                    bS3.or(JmolMolecule.getBranchBitSet(this.atoms, ((Atom)object).index, bS4, null, n, true, true));
                    continue;
                }
                jmolList.addLast((P3)object);
            }
            if (jmolList.size() == 0) {
                return;
            }
            p3 = Measure.getCenterAndPoints(jmolList)[0];
            V3 v3 = V3.newV(atom);
            v3.sub(p3);
            object = Quaternion.newVA(v3, 180.0f);
            this.moveAtoms(null, ((Quaternion)object).getMatrix(), null, bS3, atom, true);
        }
    }

    public void moveAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, V3 v3, BS bS, P3 p3, boolean bl) {
        if (matrix3f == null) {
            this.matTemp.setM(matrix3f2);
        } else {
            this.matInv.setM(matrix3f2);
            this.matInv.invert();
            this.ptTemp.set(0.0f, 0.0f, 0.0f);
            this.matTemp.mul2(matrix3f, matrix3f2);
            this.matTemp.mul2(this.matInv, this.matTemp);
        }
        if (bl) {
            this.vTemp.setT(p3);
            this.mat4.setIdentity();
            this.mat4.setTranslation(this.vTemp);
            this.mat4t.setM3(this.matTemp);
            this.mat4.mulM4(this.mat4t);
            this.mat4t.setIdentity();
            this.vTemp.scale(-1.0f);
            this.mat4t.setTranslation(this.vTemp);
            this.mat4.mulM4(this.mat4t);
        } else {
            this.mat4.setM3(this.matTemp);
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (bl) {
                this.mat4.transform(this.atoms[n]);
            } else {
                this.ptTemp.add(this.atoms[n]);
                this.mat4.transform(this.atoms[n]);
                this.ptTemp.sub(this.atoms[n]);
            }
            this.taintAtom(n, (byte)2);
            n = bS.nextSetBit(n + 1);
        }
        if (!bl) {
            this.ptTemp.scale(1.0f / (float)bS.cardinality());
            if (v3 == null) {
                v3 = new V3();
            }
            v3.add(this.ptTemp);
        }
        if (v3 != null) {
            n = bS.nextSetBit(0);
            while (n >= 0) {
                this.atoms[n].add(v3);
                n = bS.nextSetBit(n + 1);
            }
            this.mat4t.setIdentity();
            this.mat4t.setTranslation(v3);
            this.mat4.mul2(this.mat4t, this.mat4);
        }
        this.recalculatePositionDependentQuantities(bS, this.mat4);
    }

    public void recalculatePositionDependentQuantities(BS bS, Matrix4f matrix4f) {
        if (this.getHaveStraightness()) {
            this.calculateStraightness();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
        BS bS2 = this.getModelBitSet(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            this.shapeManager.refreshShapeTrajectories(n, bS, matrix4f);
            n = bS2.nextSetBit(n + 1);
        }
    }
}

