/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.io.OutputStringBuilder;
import org.jmol.io.XmlUtil;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinModelSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolList;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quadric;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.TriangleData;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelCollection
extends BondCollection {
    protected BS bsSymmetry;
    public String modelSetName;
    public Model[] models = new Model[1];
    public int modelCount;
    public SymmetryInterface[] unitCells;
    public boolean haveUnitCells;
    protected int[] modelNumbers = new int[1];
    protected int[] modelFileNumbers = new int[1];
    protected String[] modelNumbersForAtomLabel = new String[1];
    protected String[] modelNames = new String[1];
    public String[] frameTitles = new String[1];
    protected BS[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    public Properties modelSetProperties;
    protected Map<String, Object> modelSetAuxiliaryInfo;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    protected final P3 ptTemp = new P3();
    private final P3 averageAtomPoint = new P3();
    private boolean isBbcageDefault;
    private BS bboxModels;
    private BS bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    public JmolList<StateScript> stateScripts;
    private int thisStateModel;
    public JmolList<P3[]> trajectorySteps;
    protected JmolList<V3[]> vibrationSteps;
    private BS selectedMolecules;
    private int selectedMoleculeCount;
    boolean showRebondTimes;
    protected BS bsAll;
    public ShapeManager shapeManager;
    private static float hbondMin = 2.5f;
    public boolean proteinStructureTainted;
    private SymmetryInterface symTemp;
    public Hashtable<String, BS> htPeaks;

    public ModelCollection() {
        this.boxInfo.addBoundBoxPoint(P3.new3(-10.0f, -10.0f, -10.0f));
        this.boxInfo.addBoundBoxPoint(P3.new3(10.0f, 10.0f, 10.0f));
        this.stateScripts = new JmolList();
        this.thisStateModel = 0;
        this.selectedMolecules = new BS();
        this.showRebondTimes = true;
        this.proteinStructureTainted = false;
    }

    protected void mergeModelArrays(ModelSet modelSet) {
        this.atoms = modelSet.atoms;
        this.bonds = modelSet.bonds;
        this.stateScripts = modelSet.stateScripts;
        this.proteinStructureTainted = modelSet.proteinStructureTainted;
        this.thisStateModel = -1;
        this.bsSymmetry = modelSet.bsSymmetry;
        this.modelFileNumbers = modelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = modelSet.modelNumbersForAtomLabel;
        this.modelNames = modelSet.modelNames;
        this.modelNumbers = modelSet.modelNumbers;
        this.frameTitles = modelSet.frameTitles;
        this.mergeAtomArrays(modelSet);
    }

    @Override
    protected void releaseModelSet() {
        this.models = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        super.releaseModelSet();
    }

    public SymmetryInterface getUnitCell(int n) {
        if (!this.haveUnitCells || n < 0 || n >= this.modelCount) {
            return null;
        }
        if (this.models[n].simpleCage != null) {
            return this.models[n].simpleCage;
        }
        return this.unitCells == null || n >= this.unitCells.length || !this.unitCells[n].haveUnitCell() ? null : this.unitCells[n];
    }

    public void setModelCage(int n, SymmetryInterface symmetryInterface) {
        if (n < 0 || n >= this.modelCount) {
            return;
        }
        this.models[n].simpleCage = symmetryInterface;
        this.haveUnitCells = true;
    }

    public JmolList<Object> getPlaneIntersection(int n, P4 p4, float f, int n2, int n3) {
        Object object;
        P3[] p3Array = null;
        switch (n) {
            case 1614417948: {
                object = this.getUnitCell(n3);
                if (object == null) {
                    return null;
                }
                p3Array = object.getCanonicalCopy(f);
                break;
            }
            case 1679429641: {
                p3Array = this.boxInfo.getCanonicalCopy(f);
            }
        }
        object = new JmolList();
        ((JmolList)object).addLast(p3Array);
        return TriangleData.intersectPlane(p4, (JmolList<Object>)object, n2);
    }

    public String getModelName(int n) {
        return this.modelCount < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getModelAuxiliaryInfoValue(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getModelAuxiliaryInfoValue(n, "fileName");
    }

    public void setFrameTitle(BS bS, Object object) {
        if (object instanceof String) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.frameTitles[n] = (String)object;
                n = bS.nextSetBit(n + 1);
            }
        } else {
            String[] stringArray = (String[])object;
            int n = bS.nextSetBit(0);
            int n2 = 0;
            while (n >= 0) {
                if (n2 < stringArray.length) {
                    this.frameTitles[n] = stringArray[n2++];
                }
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.modelCount ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    protected void calculatePolymers(Group[] groupArray, int n, int n2, BS bS) {
        if (!this.isPDB) {
            return;
        }
        boolean bl = !this.viewer.getBoolean(603979891);
        for (int i = 0; i < this.modelCount; ++i) {
            if (bS != null && bS.get(i) || !this.models[i].isBioModel) continue;
            this.models[i].calculatePolymers(groupArray, n, n2, bS, bl);
            return;
        }
    }

    public Group[] getGroups() {
        int n = 0;
        for (int i = 0; i < this.modelCount; ++i) {
            n += this.models[i].getGroupCount();
        }
        Group[] groupArray = new Group[n];
        int n2 = 0;
        for (int i = 0; i < this.modelCount; ++i) {
            for (int j = 0; j < this.models[i].chainCount; ++j) {
                for (int k = 0; k < this.models[i].chains[j].groupCount; ++k) {
                    groupArray[n2] = this.models[i].chains[j].groups[k];
                    groupArray[n2].groupIndex = n2;
                    ++n2;
                }
            }
        }
        return groupArray;
    }

    public float[] getNotionalUnitcell() {
        SymmetryInterface symmetryInterface = this.getUnitCell(0);
        return symmetryInterface == null ? null : symmetryInterface.getNotionalUnitCell();
    }

    public boolean setCrystallographicDefaults() {
        return !this.isPDB && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public P3 getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    public P3 getBoundBoxCenter(int n) {
        if (this.isJmolDataFrameForModel(n)) {
            return new P3();
        }
        return this.boxInfo.getBoundBoxCenter();
    }

    public V3 getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBboxVertices() {
        return this.boxInfo.getBboxVertices();
    }

    public Map<String, Object> getBoundBoxInfo() {
        return this.boxInfo.getBoundBoxInfo();
    }

    public BS getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(P3 p3, P3 p32, boolean bl, float f) {
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(p3, p32, bl, f);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.eBS(this.bboxAtoms);
        }
        this.ptTemp.setT(this.boxInfo.getBoundBoxCenter());
        V3 v3 = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.eP(this.ptTemp) + " " + Escape.eP(v3) + "\n#or\n" : "";
        this.ptTemp.sub(v3);
        string = string + "boundbox corners " + Escape.eP(this.ptTemp) + " ";
        this.ptTemp.scaleAdd2(2.0f, v3, this.ptTemp);
        float f = Math.abs(8.0f * v3.x * v3.y * v3.z);
        string = string + Escape.eP(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public EnumVdw getDefaultVdwType(int n) {
        return !this.models[n].isBioModel ? EnumVdw.AUTO_BABEL : (this.models[n].hydrogenCount == 0 ? EnumVdw.AUTO_JMOL : EnumVdw.AUTO_BABEL);
    }

    public boolean setRotationRadius(int n, float f) {
        if (this.isJmolDataFrameForModel(n)) {
            this.models[n].defaultRotationRadius = f;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int n, P3 p3) {
        if (this.isJmolDataFrameForModel(n)) {
            float f = this.models[n].defaultRotationRadius;
            return f == 0.0f ? 10.0f : f;
        }
        float f = 0.0f;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.isJmolDataFrameForAtom(this.atoms[n2])) {
                n = this.atoms[n2].modelIndex;
                while (n2 >= 0 && this.atoms[n2].modelIndex == n) {
                    --n2;
                }
                continue;
            }
            Atom atom = this.atoms[n2];
            float f2 = p3.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public void calcBoundBoxDimensions(BS bS, float f) {
        if (bS != null && bS.nextSetBit(0) < 0) {
            bS = null;
        }
        if (bS == null && this.isBbcageDefault || this.atomCount < 2) {
            return;
        }
        this.bboxAtoms = BSUtil.copy(bS);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms, false);
        if (this.calcAtomsMinMax(bS, this.boxInfo) == this.atomCount) {
            this.isBbcageDefault = true;
        }
        if (bS == null) {
            this.averageAtomPoint.setT(this.getAtomSetCenter(null));
            if (this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        }
        this.boxInfo.setBbcage(f);
    }

    public BoxInfo getBoxInfo(BS bS, float f) {
        if (bS == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bS, boxInfo);
        boxInfo.setBbcage(f);
        return boxInfo;
    }

    public int calcAtomsMinMax(BS bS, BoxInfo boxInfo) {
        int n;
        boxInfo.reset();
        int n2 = 0;
        boolean bl = bS == null;
        int n3 = n = bl ? this.atomCount - 1 : bS.nextSetBit(0);
        while (n3 >= 0) {
            ++n2;
            if (!this.isJmolDataFrameForAtom(this.atoms[n3])) {
                boxInfo.addBoundBoxPoint(this.atoms[n3]);
            }
            n3 = bl ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        return n2;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            P3[] p3Array = this.unitCells[i].getUnitCellVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(p3Array[j]);
            }
        }
    }

    public float calcRotationRadiusBs(BS bS) {
        P3 p3 = this.getAtomSetCenter(bS);
        float f = 0.0f;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = p3.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (f3 > f) {
                f = f3;
            }
            n = bS.nextSetBit(n + 1);
        }
        return f == 0.0f ? 10.0f : f;
    }

    public P3[][] getCenterAndPoints(JmolList<BS[]> jmolList, boolean bl) {
        BS bS;
        BS bS2;
        int n = bl ? 1 : 0;
        int n2 = jmolList.size();
        while (--n2 >= 0) {
            BS[] bSArray = (BS[])jmolList.get(n2);
            bS2 = bSArray[0];
            bS = bSArray[1];
            n += Math.min(bS2.cardinality(), bS.cardinality());
        }
        P3[][] p3Array = new P3[2][n];
        if (bl) {
            p3Array[0][0] = new P3();
            p3Array[1][0] = new P3();
        }
        int n3 = jmolList.size();
        while (--n3 >= 0) {
            BS[] bSArray = (BS[])jmolList.get(n3);
            bS2 = bSArray[0];
            bS = bSArray[1];
            int n4 = bS2.nextSetBit(0);
            int n5 = bS.nextSetBit(0);
            while (n4 >= 0 && n5 >= 0) {
                p3Array[0][--n] = this.atoms[n4];
                p3Array[1][n] = this.atoms[n5];
                if (bl) {
                    p3Array[0][0].add(this.atoms[n4]);
                    p3Array[1][0].add(this.atoms[n5]);
                }
                n4 = bS2.nextSetBit(n4 + 1);
                n5 = bS.nextSetBit(n5 + 1);
            }
        }
        if (bl) {
            p3Array[0][0].scale(1.0f / (float)(p3Array[0].length - 1));
            p3Array[1][0].scale(1.0f / (float)(p3Array[1].length - 1));
        }
        return p3Array;
    }

    public P3 getAtomSetCenter(BS bS) {
        P3 p3 = P3.new3(0.0f, 0.0f, 0.0f);
        int n = 0;
        if (bS != null) {
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.isJmolDataFrameForAtom(this.atoms[n2])) {
                    ++n;
                    p3.add(this.atoms[n2]);
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        if (n > 0) {
            p3.scale(1.0f / (float)n);
        }
        return p3;
    }

    protected void setAPm(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        this.setAPa(bS, n, n2, f, string, fArray, stringArray);
        switch (n) {
            case 1095763988: 
            case 1632634889: {
                if (!this.viewer.getBoolean(603979944)) break;
                this.assignAromaticBonds();
            }
        }
    }

    public StateScript addStateScript(String string, BS bS, BS bS2, BS bS3, String string2, boolean bl, boolean bl2) {
        int n = this.viewer.getCurrentModelIndex();
        if (bl) {
            if (this.thisStateModel != n) {
                string = "frame " + (n < 0 ? "all #" + n : this.getModelNumberDotted(n)) + ";\n  " + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, string, bS, bS2, bS3, string2, bl2);
        if (stateScript.isValid()) {
            this.stateScripts.addLast(stateScript);
        }
        return stateScript;
    }

    protected String calculateStructuresAllExcept(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.freezeModels();
        String string = "";
        BS bS2 = BSUtil.copyInvert(bS, this.modelCount);
        if (bl4) {
            this.setDefaultStructure(bS2);
        }
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            string = string + this.models[n].calculateStructures(bl, bl2, bl3, bl4, bl5);
            n = bS2.nextSetBit(n + 1);
        }
        if (bl4) {
            this.setStructureIndexes();
        }
        return string;
    }

    public void setDefaultStructure(BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.models[n].isBioModel && this.models[n].defaultStructure == null) {
                this.models[n].defaultStructure = this.getProteinStructureState(this.models[n].bsAtoms, false, false, 0);
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    public void setProteinType(BS bS, EnumStructure enumStructure) {
        short s;
        int n;
        int n2 = -1;
        int n3 = -1;
        BS bS2 = this.getModelBitSet(bS, false);
        this.setDefaultStructure(bS2);
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            if (n3 != n4 - 1) {
                n2 = -1;
            }
            n2 = this.atoms[n4].group.setProteinStructureType(enumStructure, n2);
            n = this.atoms[n4].modelIndex;
            this.models[n].structureTainted = true;
            this.proteinStructureTainted = true;
            n3 = n4 = this.atoms[n4].group.lastAtomIndex;
            n4 = bS.nextSetBit(n4 + 1);
        }
        int[] nArray = new int[this.modelCount];
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bS2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            n3 = this.atoms[n].getStrucNo();
            if (n3 < 1000 && n3 > nArray[s]) {
                nArray[s] = n3;
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bS2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            if (this.atoms[n].getStrucNo() > 1000) {
                short s2 = s;
                int n5 = nArray[s2] + 1;
                nArray[s2] = n5;
                this.atoms[n].group.setStrucNo(n5);
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
    }

    void freezeModels() {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].freeze();
        }
    }

    public Map<EnumStructure, float[]> getStructureList() {
        return this.viewer.getStructureList();
    }

    public void setStructureList(Map<EnumStructure, float[]> map) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].setStructureList(map);
        }
    }

    public BS setConformation(BS bS) {
        BS bS2 = this.getModelBitSet(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            this.models[n].setConformation(bS);
            n = bS2.nextSetBit(n + 1);
        }
        return bS;
    }

    public BS getConformation(int n, int n2, boolean bl) {
        BS bS = new BS();
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            if (n3 != n && n >= 0) continue;
            String string = this.getAltLocListInModel(n3);
            int n4 = this.getAltLocCountInModel(n3);
            if (n2 > 0 && n2 >= n4) continue;
            BS bS2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
            if (n2 >= 0 && !this.models[n3].getPdbConformation(bS2, n2)) {
                int n5 = n4;
                while (--n5 >= 0) {
                    if (n5 == n2) continue;
                    bS2.andNot(this.getAtomBitsMDa(0x10001F, string.substring(n5, n5 + 1)));
                }
            }
            if (bS2.nextSetBit(0) < 0) continue;
            bS.or(bS2);
            if (!bl) continue;
            this.models[n3].setConformation(bS2);
        }
        return bS;
    }

    public Map<String, String> getHeteroList(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Map map;
            if (n >= 0 && n2 != n || (map = (Map)this.getModelAuxiliaryInfoValue(n2, "hetNames")) == null) continue;
            bl = true;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                hashtable.put(string, (String)entry.getValue());
            }
        }
        return bl ? hashtable : (Map)this.getModelSetAuxiliaryInfoValue("hetNames");
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Map<String, Object> getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    public Object getModelSetAuxiliaryInfoValue(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    public boolean getModelSetAuxiliaryInfoBoolean(String string) {
        Object object = this.getModelSetAuxiliaryInfoValue(string);
        return object instanceof Boolean && (Boolean)object != false;
    }

    protected int mergeTrajectories(boolean bl) {
        if (this.trajectorySteps == null) {
            if (!bl) {
                return 0;
            }
            this.trajectorySteps = new JmolList();
        }
        for (int i = this.trajectorySteps.size(); i < this.modelCount; ++i) {
            this.trajectorySteps.addLast(null);
        }
        return this.modelCount;
    }

    public int getTrajectoryIndex(int n) {
        return this.models[n].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int n) {
        return this.models[n].isTrajectory;
    }

    public boolean isTrajectoryMeasurement(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray[0];
        for (int i = 1; i <= n; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || !this.models[this.atoms[n2].modelIndex].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BS getModelBitSet(BS bS, boolean bl) {
        int n;
        BS bS2 = new BS();
        short s = 0;
        boolean bl2 = bS == null;
        int n2 = n = bl2 ? 0 : bS.nextSetBit(0);
        while (n2 >= 0 && n2 < this.atomCount) {
            s = this.atoms[n2].modelIndex;
            bS2.set(s);
            if (bl) {
                int n3 = this.models[s].trajectoryBaseIndex;
                for (int i = 0; i < this.modelCount; ++i) {
                    if (this.models[i].trajectoryBaseIndex != n3) continue;
                    bS2.set(i);
                }
            }
            n2 = this.models[s].firstAtomIndex + this.models[s].atomCount - 1;
            n2 = bl2 ? n2 + 1 : bS.nextSetBit(n2 + 1);
        }
        return bS2;
    }

    public BS getIterativeModels(boolean bl) {
        BS bS = new BS();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bl && this.isJmolDataFrameForModel(i) || this.models[i].trajectoryBaseIndex != i) continue;
            bS.set(i);
        }
        return bS;
    }

    public boolean isTrajectorySubFrame(int n) {
        return this.models[n].isTrajectory && this.models[n].trajectoryBaseIndex != n;
    }

    public BS selectDisplayedTrajectories(BS bS) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isTrajectory || this.atoms[this.models[i].firstAtomIndex].modelIndex == i) continue;
            bS.clear(i);
        }
        return bS;
    }

    public void fillAtomData(AtomData atomData, int n) {
        Object object;
        if ((n & 4) != 0) {
            this.getMolecules();
            atomData.bsMolecules = new BS[this.molecules.length];
            atomData.atomMolecule = new int[this.atomCount];
            for (int i = 0; i < this.molecules.length; ++i) {
                atomData.bsMolecules[i] = this.molecules[i].atomList;
                object = atomData.bsMolecules[i];
                int n2 = ((BS)object).nextSetBit(0);
                while (n2 >= 0) {
                    atomData.atomMolecule[n2] = i;
                    n2 = ((BS)object).nextSetBit(n2 + 1);
                }
            }
        }
        if ((n & 8) != 0) {
            object = new int[1];
            atomData.hAtomRadius = (float)this.viewer.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.calculateHydrogens(atomData.bsSelected, (int[])object, false, true, null);
            atomData.hydrogenAtomCount = object[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? (atomData.bsSelected == null ? 0 : Math.max(0, atomData.bsSelected.nextSetBit(0))) : this.models[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        this.fillADa(atomData, n);
    }

    public String getModelNumberDotted(int n) {
        return this.modelCount < 1 || n >= this.modelCount || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        if (n == Integer.MAX_VALUE) {
            n = this.modelCount - 1;
        }
        return this.modelNumbers[n];
    }

    public int getModelFileNumber(int n) {
        return this.modelFileNumbers[n];
    }

    public Properties getModelProperties(int n) {
        return this.models[n].properties;
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.models[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Map<String, Object> getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.models[n].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.models[n].auxiliaryInfo.put((String)object, object2);
    }

    public Object getModelAuxiliaryInfoValue(int n, String string) {
        if (n < 0) {
            return null;
        }
        return this.models[n].auxiliaryInfo.get(string);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Map<String, Object> map = this.models[n].auxiliaryInfo;
        return map != null && map.containsKey(string) && (Boolean)map.get(string) != false;
    }

    protected int getModelAuxiliaryInfoInt(int n, String string) {
        Map<String, Object> map = this.models[n].auxiliaryInfo;
        if (map != null && map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        return Integer.MIN_VALUE;
    }

    public String getModelAtomProperty(Atom atom, String string) {
        Object object = this.getModelAuxiliaryInfoValue(atom.modelIndex, string);
        if (!(object instanceof Object[])) {
            return "";
        }
        int n = atom.index - this.models[atom.modelIndex].firstAtomIndex;
        Object[] objectArray = (Object[])object;
        return n < objectArray.length ? objectArray[n].toString() : "";
    }

    public int getInsertionCountInModel(int n) {
        return this.models[n].nInsertions;
    }

    public String getModelFileType(int n) {
        return (String)this.getModelAuxiliaryInfoValue(n, "fileType");
    }

    public static int modelFileNumberFromFloat(float f) {
        int n;
        int n2 = (int)Math.floor(f);
        for (n = (int)Math.floor(((double)(f - (float)n2) + 1.0E-5) * 10000.0); n != 0 && n % 10 == 0; n /= 10) {
        }
        return n2 * 1000000 + n;
    }

    public int getAltLocCountInModel(int n) {
        return this.models[n].nAltLocs;
    }

    public int getChainCount(boolean bl) {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getChainCount(bl);
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (this.isTrajectorySubFrame(n2)) continue;
            n += this.models[n2].getBioPolymerCount();
        }
        return n;
    }

    public int getBioPolymerCountInModel(int n) {
        return n < 0 ? this.getBioPolymerCount() : (this.isTrajectorySubFrame(n) ? 0 : this.models[n].getBioPolymerCount());
    }

    public void getPolymerPointsAndVectors(BS bS, JmolList<P3[]> jmolList, boolean bl, float f) {
        for (int i = 0; i < this.modelCount; ++i) {
            this.models[i].getPolymerPointsAndVectors(bS, jmolList, bl, f);
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (n < 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.isTrajectorySubFrame(i)) continue;
                this.models[i].recalculateLeadMidpointsAndWingVectors();
            }
            return;
        }
        this.models[n].recalculateLeadMidpointsAndWingVectors();
    }

    public P3[] getPolymerLeadMidPoints(int n, int n2) {
        return this.models[n].getPolymerLeadMidPoints(n2);
    }

    public int getChainCountInModel(int n, boolean bl) {
        if (n < 0) {
            return this.getChainCount(bl);
        }
        return this.models[n].getChainCount(bl);
    }

    public int getGroupCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getGroupCount();
        }
        return n;
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.models[n].getGroupCount();
    }

    public void calcSelectedGroupsCount(BS bS) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedGroupsCount(bS);
        }
    }

    public void calcSelectedMonomersCount(BS bS) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedMonomersCount(bS);
        }
    }

    public void calcRasmolHydrogenBonds(BS bS, BS bS2, JmolList<Bond> jmolList, boolean bl, int n, boolean bl2, BS bS3) {
        boolean bl3 = bS2 == null || bS.equals(bS2);
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (!this.models[n2].isBioModel || this.models[n2].trajectoryBaseIndex != n2) continue;
            if (jmolList == null) {
                this.models[n2].clearRasmolHydrogenBonds(bS);
                if (!bl3) {
                    this.models[n2].clearRasmolHydrogenBonds(bS2);
                }
            }
            this.models[n2].getRasmolHydrogenBonds(bS, bS2, jmolList, bl, n, bl2, bS3);
        }
    }

    public void calculateStraightness() {
        if (this.getHaveStraightness()) {
            return;
        }
        char c = 'S';
        char c2 = this.viewer.getQuaternionFrame();
        int n = this.viewer.getInt(0x21000012);
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            this.models[n2].calculateStraightness(this.viewer, c, c2, n);
        }
        this.setHaveStraightness(true);
    }

    public Quaternion[] getAtomGroupQuaternions(BS bS, int n, char c) {
        int n2 = 0;
        JmolList<Quaternion> jmolList = new JmolList<Quaternion>();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0 && n2 < n) {
            block6: {
                Quaternion quaternion;
                Group group;
                block5: {
                    group = this.atoms[n3].group;
                    quaternion = group.getQuaternion(c);
                    if (quaternion != null) break block5;
                    if (group.seqcode == Integer.MIN_VALUE) {
                        quaternion = group.getQuaternionFrame(this.atoms);
                    }
                    if (quaternion == null) break block6;
                }
                ++n2;
                jmolList.addLast(quaternion);
                n3 = group.lastAtomIndex;
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        return jmolList.toArray(new Quaternion[jmolList.size()]);
    }

    public String getPdbAtomData(BS bS, OutputStringBuilder outputStringBuilder) {
        int n;
        if (this.atomCount == 0 || bS.nextSetBit(0) < 0) {
            return "";
        }
        if (outputStringBuilder == null) {
            outputStringBuilder = new OutputStringBuilder(null);
        }
        short s = this.atoms[bS.nextSetBit((int)0)].modelIndex;
        short s2 = -1;
        boolean bl = "PQR".equals(outputStringBuilder.type);
        String string = "%6.2Q%6.2b          ";
        if (bl) {
            string = "%8.4P%7.4V       ";
            float f = 0.0f;
            n = bS.nextSetBit(0);
            while (n >= 0) {
                f += this.atoms[n].getPartialCharge();
                n = bS.nextSetBit(n + 1);
            }
            outputStringBuilder.append("REMARK   1 PQR file generated by Jmol " + Viewer.getJmolVersion()).append("\nREMARK   1 created " + new Date()).append("\nREMARK   1 Forcefield Used: unknown\nREMARK   1").append("\nREMARK   5").append("\nREMARK   6 Total charge on this protein: " + f + " e\nREMARK   6\n");
        }
        int n2 = bS.length() - 1;
        n = s != this.atoms[n2].modelIndex ? 1 : 0;
        SB sB = n != 0 ? null : new SB();
        boolean bl2 = this.models[s].isPdbWithMultipleBonds;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Bond[] bondArray;
            Atom atom = this.atoms[n3];
            if (n != 0 && atom.modelIndex != s2) {
                if (s2 != -1) {
                    outputStringBuilder.append("ENDMDL\n");
                }
                s2 = atom.modelIndex;
                outputStringBuilder.append("MODEL     " + (s2 + 1) + "\n");
            }
            String string2 = atom.getAtomName();
            boolean bl3 = atom.getElementSymbol().length() == 2 || string2.length() >= 4 || Character.isDigit(string2.charAt(0));
            boolean bl4 = this.models[atom.modelIndex].isBioModel;
            boolean bl5 = atom.isHetero();
            LabelToken[] labelTokenArray = !bl4 ? (bl3 ? LabelToken.compile(this.viewer, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.viewer, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl5 ? (bl3 ? LabelToken.compile(this.viewer, "HETATM%5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.viewer, "HETATM%5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl3 ? LabelToken.compile(this.viewer, "ATOM  %5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.viewer, "ATOM  %5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)));
            String string3 = atom.getElementSymbolIso(false).toUpperCase();
            outputStringBuilder.append(LabelToken.formatLabelAtomArray(this.viewer, atom, labelTokenArray, '\u0000', null)).append(string3.length() == 1 ? " " + string3 : string3.substring(0, 2)).append("  \n");
            if (n == 0 && (!bl4 || bl5 || bl2) && (bondArray = atom.getBonds()) != null) {
                block6: for (int i = 0; i < bondArray.length; ++i) {
                    int n4;
                    int n5 = atom.getAtomNumber();
                    Atom atom2 = bondArray[i].getOtherAtom(atom);
                    if (!bS.get(atom2.index) || (n4 = bondArray[i].getCovalentOrder()) == 1 && bl2 && !bl5) continue;
                    int n6 = atom2.getAtomNumber();
                    switch (n4) {
                        case 2: 
                        case 3: {
                            if (n6 < n5) continue block6;
                        }
                        case 1: {
                            sB.append("CONECT").append(TextFormat.formatStringI("%5i", "i", n5));
                            for (int j = 0; j < n4; ++j) {
                                sB.append(TextFormat.formatStringI("%5i", "i", n6));
                            }
                            sB.appendC('\n');
                        }
                    }
                }
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (n != 0) {
            outputStringBuilder.append("ENDMDL\n");
        } else {
            outputStringBuilder.append(sB.toString());
        }
        return outputStringBuilder.toString();
    }

    public String getPdbData(int n, String string, BS bS, Object[] objectArray, OutputStringBuilder outputStringBuilder) {
        if (this.isJmolDataFrameForModel(n)) {
            n = this.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        boolean bl = this.models[n].isBioModel;
        if (objectArray == null && !bl) {
            return null;
        }
        Model model = this.models[n];
        if (outputStringBuilder == null) {
            outputStringBuilder = new OutputStringBuilder(null);
        }
        SB sB = new SB();
        boolean bl2 = string.indexOf("draw") >= 0;
        BS bS2 = null;
        BS bS3 = new BS();
        char c = '\u0000';
        LabelToken[] labelTokenArray = LabelToken.compile(this.viewer, "ATOM  %-6i%4a%1A%3n %1c%4R%1E   ", '\u0000', null);
        if (objectArray == null) {
            c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
            model.getPdbData(this.viewer, string, c, bl2, bS, outputStringBuilder, labelTokenArray, sB, bS3);
            bS2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        } else {
            bS2 = (BS)objectArray[0];
            float[] fArray = (float[])objectArray[1];
            float[] fArray2 = (float[])objectArray[2];
            float[] fArray3 = (float[])objectArray[3];
            boolean bl3 = fArray3 != null;
            P3 p3 = (P3)objectArray[4];
            P3 p32 = (P3)objectArray[5];
            P3 p33 = (P3)objectArray[6];
            P3 p34 = (P3)objectArray[7];
            outputStringBuilder.append("REMARK   6 Jmol PDB-encoded data: ").append(string).append(";\n");
            outputStringBuilder.append("REMARK   6 Jmol data").append(" min = ").append(Escape.eP(p3)).append(" max = ").append(Escape.eP(p32)).append(" unScaledXyz = xyz * ").append(Escape.eP(p33)).append(" + ").append(Escape.eP(p34)).append(";\n");
            String string2 = "";
            Atom atom = null;
            int n2 = bS2.nextSetBit(0);
            int n3 = 0;
            while (n2 >= 0) {
                float f;
                float f2 = fArray[n3];
                float f3 = fArray2[n3];
                float f4 = f = bl3 ? fArray3[n3] : 0.0f;
                if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f))) {
                    Atom atom2 = this.atoms[n2];
                    outputStringBuilder.append(LabelToken.formatLabelAtomArray(this.viewer, atom2, labelTokenArray, '\u0000', null));
                    if (bl) {
                        bS3.set(n2);
                    }
                    outputStringBuilder.append(TextFormat.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %2s    %s\n", "ssF", new Object[]{atom2.getElementSymbolIso(false).toUpperCase(), string2, new float[]{f2, f3, f, 0.0f}}));
                    if (atom != null && atom.getPolymerIndexInModel() == atom2.getPolymerIndexInModel()) {
                        sB.append("CONECT").append(TextFormat.formatStringI("%5i", "i", atom.getAtomNumber())).append(TextFormat.formatStringI("%5i", "i", atom2.getAtomNumber())).appendC('\n');
                    }
                    atom = atom2;
                }
                n2 = bS2.nextSetBit(n2 + 1);
                ++n3;
            }
        }
        outputStringBuilder.append(sB.toString());
        if (bl2) {
            return outputStringBuilder.toString();
        }
        bS.and(bS2);
        if (bl) {
            outputStringBuilder.append("\n\n" + this.getProteinStructureState(bS3, false, c == 'R', 1));
        }
        return outputStringBuilder.toString();
    }

    public boolean isJmolDataFrameForModel(int n) {
        return n >= 0 && n < this.modelCount && this.models[n].isJmolDataFrame;
    }

    private boolean isJmolDataFrameForAtom(Atom atom) {
        return this.models[atom.modelIndex].isJmolDataFrame;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.models[string == null ? this.models[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.models[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable<String, Integer>();
            }
            this.models[n2].dataSourceFrame = n;
            this.models[n2].jmolFrameType = string;
            model.dataFrames.put(string, n2);
        }
        if (string.startsWith("quaternion") && string.indexOf("deriv") < 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, n2);
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.models[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = this.models[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    protected void clearDataFrameReference(int n) {
        for (int i = 0; i < this.modelCount; ++i) {
            Map<String, Integer> map = this.models[i].dataFrames;
            if (map == null) continue;
            Iterator<Integer> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != n) continue;
                iterator.remove();
            }
        }
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int n, StateManager.Orientation orientation) {
        this.models[n].orientation = orientation;
    }

    public StateManager.Orientation getModelOrientation(int n) {
        return this.models[n].orientation;
    }

    public String getPDBHeader(int n) {
        return this.models[n].isBioModel ? this.models[n].getFullPDBHeader() : this.getFileHeader(n);
    }

    public String getFileHeader(int n) {
        if (n < 0) {
            return "";
        }
        if (this.models[n].isBioModel) {
            return this.models[n].getFullPDBHeader();
        }
        String string = (String)this.getModelAuxiliaryInfoValue(n, "fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfoValue(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfoValue(n, "insertionCodes");
        return string == null ? "" : string;
    }

    public int getModelSymmetryCount(int n) {
        String[] stringArray;
        return this.models[n].biosymmetryCount > 0 || this.unitCells == null || this.unitCells[n] == null || (stringArray = this.unitCells[n].getSymmetryOperations()) == null ? this.models[n].biosymmetryCount : stringArray.length;
    }

    public String getSymmetryOperation(int n, String string, int n2, P3 p3, P3 p32, String string2, boolean bl) {
        Map<String, Object> map = this.getSymTemp(true).getSpaceGroupInfo((ModelSet)this, n, string, n2, p3, p32, string2);
        if (map == null) {
            return "";
        }
        return this.symTemp.getSymmetryOperationInfo(map, n2, string2, bl);
    }

    public int[] getModelCellRange(int n) {
        if (this.unitCells == null) {
            return null;
        }
        return this.unitCells[n].getCellRange();
    }

    public boolean modelHasVibrationVectors(int n) {
        if (this.vibrationVectors != null) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (n >= 0 && this.atoms[n2].modelIndex != n || this.vibrationVectors[n2] == null || !(this.vibrationVectors[n2].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public BS getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BS bS = new BS();
        for (int i = 0; i < this.modelCount; ++i) {
            bS.or(this.elementsPresent[i]);
        }
        return bS;
    }

    private String getSymmetryInfoAsStringForModel(int n) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "no symmetry information" : symmetryInterface.getSymmetryInfoString();
    }

    public int getMoleculeIndex(int n, boolean bl) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return bl ? this.molecules[i].indexInModel : i;
        }
        return 0;
    }

    public BS getMoleculeBitSet(BS bS) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BS bS2 = BSUtil.copy(bS);
        BS bS3 = BSUtil.copy(bS);
        int n = 0;
        BS bS4 = new BS();
        while ((n = bS3.length() - 1) >= 0) {
            bS4 = this.getMoleculeBitSetForAtom(n);
            if (bS4 == null) {
                bS3.clear(n);
                bS2.clear(n);
                continue;
            }
            bS3.andNot(bS4);
            bS2.or(bS4);
        }
        return bS2;
    }

    public BS getMoleculeBitSetForAtom(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public V3 getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        V3 v3 = (V3)this.getModelAuxiliaryInfoValue(n, "dipole");
        if (v3 == null) {
            v3 = (V3)this.getModelAuxiliaryInfoValue(n, "DIPOLE_VEC");
        }
        return v3;
    }

    public V3 calculateMolecularDipole(int n) {
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        V3 v3 = new V3();
        V3 v32 = new V3();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != n) continue;
            float f3 = this.partialCharges[i];
            if (f3 < 0.0f) {
                ++n3;
                f2 += f3;
                v32.scaleAdd2(f3, this.atoms[i], v32);
                continue;
            }
            if (!(f3 > 0.0f)) continue;
            ++n2;
            f += f3;
            v3.scaleAdd2(f3, this.atoms[i], v3);
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        v3.scale(1.0f / f);
        v32.scale(1.0f / f2);
        v3.sub(v32);
        Logger.warn("CalculateMolecularDipole: this is an approximate result -- needs checking");
        v3.scale(f * 4.8f);
        return v3;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (n < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (n != i) continue;
            n2 += this.models[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount(BS bS) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        BS bS2 = new BS();
        for (int i = 0; i < this.moleculeCount; ++i) {
            BSUtil.copy2(bS, bS2);
            bS2.and(this.molecules[i].atomList);
            if (bS2.length() <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    public void setCentroid(int n, int n2, int[] nArray) {
        SymmetryInterface symmetryInterface = this.getUnitCell(this.atoms[n].modelIndex);
        if (symmetryInterface == null) {
            return;
        }
        symmetryInterface.setCentroid((ModelSet)this, n, n2, nArray);
    }

    public JmolMolecule[] getMolecules() {
        int n;
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new JmolMolecule[4];
        }
        this.moleculeCount = 0;
        Model model = null;
        BS[] bSArray = new BS[this.modelCount];
        JmolList<BS> jmolList = null;
        for (n = 0; n < this.modelCount; ++n) {
            bSArray[n] = this.viewer.getModelUndeletedAtomsBitSet(n);
            model = this.models[n];
            model.moleculeCount = 0;
            jmolList = model.getBioBranches(jmolList);
        }
        this.molecules = JmolMolecule.getMolecules(this.atoms, bSArray, jmolList, null);
        n = this.moleculeCount = this.molecules.length;
        while (--n >= 0) {
            model = this.models[this.molecules[n].modelIndex];
            model.firstMoleculeIndex = n;
            ++model.moleculeCount;
        }
        return this.molecules;
    }

    protected void initializeBspf() {
        if (this.bspf != null && this.bspf.isInitialized()) {
            return;
        }
        if (this.showRebondTimes) {
            Logger.startTimer("build bspf");
        }
        Bspf bspf = new Bspf(3);
        if (Logger.debugging) {
            Logger.debug("sequential bspt order");
        }
        BS bS = BSUtil.newBitSet(this.modelCount);
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if (atom.isDeleted() || this.isTrajectorySubFrame(atom.modelIndex)) continue;
            bspf.addTuple(this.models[atom.modelIndex].trajectoryBaseIndex, atom);
            bS.set(atom.modelIndex);
        }
        if (this.showRebondTimes) {
            Logger.checkTimer("build bspf", false);
            bspf.stats();
        }
        n = bS.nextSetBit(0);
        while (n >= 0) {
            bspf.validateModel(n, true);
            n = bS.nextSetBit(n + 1);
        }
        bspf.validate(true);
        this.bspf = bspf;
    }

    protected void initializeBspt(int n) {
        this.initializeBspf();
        if (this.bspf.isInitializedIndex(n)) {
            return;
        }
        this.bspf.initialize(n, this.atoms, this.viewer.getModelUndeletedAtomsBitSet(n));
    }

    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, P3 p3, float f) {
        if (n < 0) {
            atomIndexIterator.setCenter(p3, f);
            return;
        }
        this.initializeBspt(n);
        atomIndexIterator.setModel(this, n, this.models[n].firstAtomIndex, Integer.MAX_VALUE, p3, f, null);
    }

    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, int n2, float f, RadiusData radiusData) {
        if (n < 0) {
            n = this.atoms[n2].modelIndex;
        }
        n = this.models[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        atomIndexIterator.setModel(this, n, this.models[n].firstAtomIndex, n2, this.atoms[n2], f, radiusData);
    }

    public AtomIndexIterator getSelectedAtomIterator(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AtomIteratorWithinModel atomIteratorWithinModel;
        this.initializeBspf();
        if (bl4) {
            BS bS2 = this.getModelBitSet(bS, false);
            int n = bS2.nextSetBit(0);
            while (n >= 0) {
                this.initializeBspt(n);
                n = bS2.nextSetBit(n + 1);
            }
            atomIteratorWithinModel = new AtomIteratorWithinModelSet(bS2);
        } else {
            atomIteratorWithinModel = new AtomIteratorWithinModel();
        }
        atomIteratorWithinModel.initialize(this.bspf, bS, bl, bl2, bl3, this.viewer.isParallel());
        return atomIteratorWithinModel;
    }

    @Override
    public int getBondCountInModel(int n) {
        return n < 0 ? this.bondCount : this.models[n].getBondCount();
    }

    public int calculateStruts(BS bS, BS bS2) {
        this.makeConnections2(0.0f, Float.MAX_VALUE, 32768, 12291, bS, bS2, null, false, false, 0.0f);
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        Model model = this.models[this.atoms[n].modelIndex];
        return model.isBioModel ? model.calculateStruts((ModelSet)this, bS, bS2) : 0;
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.atomCount : this.models[n].atomCount;
    }

    public BS getModelAtomBitSetIncludingDeletedBs(BS bS) {
        BS bS2 = new BS();
        if (bS == null && this.bsAll == null) {
            this.bsAll = BSUtil.setAll(this.atomCount);
        }
        if (bS == null) {
            bS2.or(this.bsAll);
        } else {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                bS2.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                n = bS.nextSetBit(n + 1);
            }
        }
        return bS2;
    }

    public BS getModelAtomBitSetIncludingDeleted(int n, boolean bl) {
        BS bS;
        BS bS2 = bS = n < 0 ? this.bsAll : this.models[n].bsAtoms;
        if (bS == null) {
            bS = this.bsAll = BSUtil.setAll(this.atomCount);
        }
        return bl ? BSUtil.copy(bS) : bS;
    }

    protected BS getAtomBitsMaybeDeleted(int n, Object object) {
        switch (n) {
            default: {
                return this.getAtomBitsMDa(n, object);
            }
            case 0x100009: 
            case 1678770178: {
                return this.getAtomBitsMDb(n, object);
            }
            case 1073741864: {
                return this.getBasePairBits((String)object);
            }
            case 1679429641: {
                BoxInfo boxInfo = this.getBoxInfo((BS)object, 1.0f);
                BS bS = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int n2 = bS.nextSetBit(0);
                while (n2 >= 0) {
                    if (!boxInfo.isWithin(this.atoms[n2])) {
                        bS.clear(n2);
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                return bS;
            }
            case 1095761925: {
                BS bS = new BS();
                int[] nArray = (int[])object;
                P3 p3 = P3.new3((float)nArray[0] / 1000.0f, (float)nArray[1] / 1000.0f, (float)nArray[2] / 1000.0f);
                P3 p32 = new P3();
                boolean bl = !this.viewer.getBoolean(603979848);
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    if (!this.isInLatticeCell(n3, p3, p32, bl)) continue;
                    bS.set(n3);
                }
                return bS;
            }
            case 1095761934: {
                return this.getMoleculeBitSet((BS)object);
            }
            case 1087373320: {
                return this.getSequenceBits((String)object, null);
            }
            case 1048615: {
                int[] nArray = (int[])object;
                int n4 = nArray[0];
                int n5 = nArray[1];
                char c = (char)nArray[2];
                BS bS = new BS();
                boolean bl = this.viewer.getBoolean(603979822);
                if (!bl) {
                    c = Character.toUpperCase(c);
                }
                int n6 = this.modelCount;
                while (--n6 >= 0) {
                    if (!this.models[n6].isBioModel) continue;
                    this.models[n6].selectSeqcodeRange(n4, n5, c, bS, bl);
                }
                return bS;
            }
            case 3145772: {
                BS bS = BSUtil.newBitSet(this.atomCount);
                short s = -1;
                int n7 = 0;
                int n8 = this.atomCount;
                block15: while (--n8 >= 0) {
                    Atom atom = this.atoms[n8];
                    BS bS2 = atom.getAtomSymmetry();
                    if (bS2 == null) continue;
                    if (atom.modelIndex != s) {
                        s = atom.modelIndex;
                        if (this.getModelCellRange(s) == null) continue;
                        n7 = this.getModelSymmetryCount(s);
                    }
                    int n9 = 0;
                    int n10 = n7;
                    while (--n10 >= 0) {
                        if (!bS2.get(n10) || ++n9 <= 1) continue;
                        bS.set(n8);
                        continue block15;
                    }
                }
                return bS;
            }
            case 1089470478: {
                return BSUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = BSUtil.newBitSet(this.atomCount)) : this.bsSymmetry);
            }
            case 1614417948: 
        }
        BS bS = new BS();
        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return bS;
        }
        P3 p3 = P3.new3(1.0f, 1.0f, 1.0f);
        P3 p33 = new P3();
        int n11 = this.atomCount;
        while (--n11 >= 0) {
            if (!this.isInLatticeCell(n11, p3, p33, false)) continue;
            bS.set(n11);
        }
        return bS;
    }

    private boolean isInLatticeCell(int n, P3 p3, P3 p32, boolean bl) {
        short s = this.atoms[n].modelIndex;
        SymmetryInterface symmetryInterface = this.getUnitCell(s);
        if (symmetryInterface == null) {
            return false;
        }
        p32.setT(this.atoms[n]);
        symmetryInterface.toFractional(p32, bl);
        float f = 0.02f;
        if (p32.x < p3.x - 1.0f - f || p32.x > p3.x + f) {
            return false;
        }
        if (p32.y < p3.y - 1.0f - f || p32.y > p3.y + f) {
            return false;
        }
        return !(p32.z < p3.z - 1.0f - f) && !(p32.z > p3.z + f);
    }

    public BS getAtomsWithinRD(float f, BS bS, boolean bl, RadiusData radiusData) {
        BS bS2 = new BS();
        BS bS3 = this.getIterativeModels(false);
        bS = BSUtil.andNot(bS, this.viewer.getDeletedAtoms());
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        if (bl) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                int n2 = this.modelCount;
                while (--n2 >= 0) {
                    if (!bS3.get(n2)) continue;
                    if (f < 0.0f) {
                        this.getAtomsWithin(f, this.atoms[n].getFractionalUnitCoordPt(true), bS2, -1);
                        continue;
                    }
                    this.setIteratorForAtom(atomIndexIterator, n2, n, f, radiusData);
                    atomIndexIterator.addAtoms(bS2);
                }
                n = bS.nextSetBit(n + 1);
            }
        } else {
            bS2.or(bS);
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (f < 0.0f) {
                    this.getAtomsWithin(f, this.atoms[n], bS2, this.atoms[n].modelIndex);
                } else {
                    this.setIteratorForAtom(atomIndexIterator, -1, n, f, radiusData);
                    atomIndexIterator.addAtoms(bS2);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        atomIndexIterator.release();
        return bS2;
    }

    public BS getGroupsWithin(int n, BS bS) {
        BS bS2 = this.getIterativeModels(false);
        BS bS3 = new BS();
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (!bS2.get(n2) || !this.models[n2].isBioModel) continue;
            this.models[n2].getGroupsWithin(n, bS, bS3);
        }
        return bS3;
    }

    public BS getAtomsWithin(float f, P3 p3, BS bS, int n) {
        if (bS == null) {
            bS = new BS();
        }
        if (f < 0.0f) {
            f = -f;
            P3 p32 = new P3();
            P3 p33 = new P3();
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                Atom atom = this.atoms[n2];
                if (n >= 0 && this.atoms[n2].modelIndex != n || bS.get(n2) || !(atom.getFractionalUnitDistance(p3, p32, p33) <= f)) continue;
                bS.set(atom.index);
            }
            return bS;
        }
        BS bS2 = this.getIterativeModels(true);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            if (!bS2.get(n3)) continue;
            this.setIteratorForAtom(atomIndexIterator, -1, this.models[n3].firstAtomIndex, -1.0f, null);
            atomIndexIterator.setCenter(p3, f);
            atomIndexIterator.addAtoms(bS);
        }
        atomIndexIterator.release();
        return bS;
    }

    private BS getBasePairBits(String string) {
        BS bS = new BS();
        if (string.length() % 2 != 0) {
            return bS;
        }
        BS bS2 = null;
        BS bS3 = null;
        JmolList<Bond> jmolList = new JmolList<Bond>();
        if (string.length() == 0) {
            bS2 = bS3 = this.viewer.getModelUndeletedAtomsBitSet(-1);
            this.calcRasmolHydrogenBonds(bS2, bS3, jmolList, true, 1, false, null);
        } else {
            int n = 0;
            while (n < string.length()) {
                if ((bS2 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0 || (bS3 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0) continue;
                this.calcRasmolHydrogenBonds(bS2, bS3, jmolList, true, 1, false, null);
            }
        }
        BS bS4 = new BS();
        int n = jmolList.size();
        while (--n >= 0) {
            Bond bond = (Bond)jmolList.get(n);
            bS4.set(bond.atom1.index);
            bS4.set(bond.atom2.index);
        }
        return this.getAtomBitsMDb(1087373318, bS4);
    }

    public BS getSequenceBits(String string, BS bS) {
        if (bS == null) {
            bS = this.viewer.getModelUndeletedAtomsBitSet(-1);
        }
        BS bS2 = new BS();
        if (string.length() > 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (!this.models[i].isBioModel) continue;
                this.models[i].getSequenceBits(string, bS, bS2);
            }
        }
        return bS2;
    }

    public void deleteBonds(BS bS, boolean bl) {
        if (!bl) {
            BS bS2 = new BS();
            BS bS3 = new BS();
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                Atom atom = this.bonds[n].atom1;
                if (!this.models[atom.modelIndex].isModelKit) {
                    bS2.clearAll();
                    bS3.clearAll();
                    bS2.set(atom.index);
                    bS3.set(this.bonds[n].getAtomIndex2());
                    this.addStateScript("connect ", null, bS2, bS3, "delete", false, true);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        this.dBb(bS, bl);
    }

    protected int[] makeConnections2(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        boolean bl3;
        boolean bl4;
        if (bS3 == null) {
            bS3 = new BS();
        }
        boolean bl5 = n == 65535;
        boolean bl6 = bl4 = n == 131071;
        if (bl4) {
            n = 1;
        }
        boolean bl7 = Bond.isOrderH(n);
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        float f4 = f * f;
        float f5 = f2 * f2;
        switch (n2) {
            case 12291: {
                return this.deleteConnections(f, f2, n, bS, bS2, bl, bl4, f4, f5);
            }
            case 603979874: 
            case 1073741852: {
                if (n != 515) {
                    return this.autoBond(bS, bS2, bS3, bl, bl7, n2 == 603979874);
                }
                bl9 = true;
                bl11 = true;
                break;
            }
            case 1087373321: {
                bl8 = true;
                break;
            }
            case 1073742025: {
                bl9 = true;
                break;
            }
            case 0x40000050: {
                bl10 = true;
            }
        }
        this.defaultCovalentMad = this.viewer.getMadBond();
        boolean bl12 = f < 0.0f;
        boolean bl13 = bl3 = f2 < 0.0f;
        if (bl12) {
            f = -f;
        }
        if (bl3) {
            f2 = -f2;
        }
        short s = this.getDefaultMadFromOrder(n);
        int n3 = 0;
        int n4 = 0;
        Bond bond = null;
        int n5 = bl ? 1 : this.atomCount;
        Atom atom = null;
        Atom atom2 = null;
        float f6 = 0.0f;
        float f7 = 0.0f;
        short s2 = (short)(n | 0x20000);
        int n6 = bS.nextSetBit(0);
        while (n6 >= 0) {
            block28: {
                int n7;
                block27: {
                    block26: {
                        if (!bl) break block26;
                        bond = this.bonds[n6];
                        atom = bond.atom1;
                        atom2 = bond.atom2;
                        break block27;
                    }
                    atom = this.atoms[n6];
                    if (atom.isDeleted()) break block28;
                }
                int n8 = n7 = bl ? n5 : bS2.nextSetBit(0);
                while (n7 >= 0) {
                    block30: {
                        block29: {
                            if (bl) break block29;
                            if (n7 == n6) break block30;
                            atom2 = this.atoms[n7];
                            if (atom.modelIndex != atom2.modelIndex || atom2.isDeleted() || atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != '\u0000' && atom2.alternateLocationID != '\u0000') break block30;
                            bond = atom.getBond(atom2);
                        }
                        if (!(bond == null && (bl8 || bl9) || bond != null && bl10)) {
                            float f8 = atom.distanceSquared(atom2);
                            if (bl12 || bl3) {
                                f6 = atom.distance(atom2);
                                f7 = atom.getBondingRadiusFloat() + atom2.getBondingRadiusFloat();
                            }
                            if (!(!bl12 ? f8 < f4 : f6 < f7 * f) && !(!bl3 ? f8 > f5 : f6 > f7 * f2)) {
                                if (bond != null) {
                                    if (!bl8 && !bl5) {
                                        bond.setOrder(n);
                                        this.bsAromatic.clear(bond.index);
                                    }
                                    if (!bl8 || bl5 || n == bond.order || s2 == bond.order || bl7 && bond.isHydrogen()) {
                                        bS3.set(bond.index);
                                        ++n4;
                                    }
                                } else {
                                    bS3.set(this.bondAtoms((Atom)atom, (Atom)atom2, (int)n, (short)s, (BS)bS3, (float)f3, (boolean)bl2, (boolean)true).index);
                                    ++n3;
                                }
                            }
                        }
                    }
                    n7 = bl ? n7 - 1 : bS2.nextSetBit(n7 + 1);
                }
            }
            n6 = bS.nextSetBit(n6 + 1);
        }
        if (bl11) {
            this.assignAromaticBondsBs(true, bS3);
        }
        if (!bl8) {
            this.shapeManager.setShapeSizeBs(1, Integer.MIN_VALUE, null, bS3);
        }
        return new int[]{n3, n4};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBondBs4(BS bS, BS bS2, BS bS3, BS bS4, short s, boolean bl) {
        BS bS5;
        int n;
        boolean bl2;
        if (bl) {
            return this.autoBond_Pre_11_9_24(bS, bS2, bS3, bS4, s);
        }
        if (this.atomCount == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getFloat(0x22000004);
        float f2 = this.viewer.getFloat(570425364);
        float f3 = f2 * f2;
        int n2 = 0;
        if (this.showRebondTimes) {
            Logger.startTimer("autobond");
        }
        short s2 = -1;
        boolean bl3 = bl2 = bS == null;
        if (bl2) {
            n = 0;
            bS5 = null;
        } else {
            if (bS.equals(bS2)) {
                bS5 = bS;
            } else {
                bS5 = BSUtil.copy(bS);
                bS5.or(bS2);
            }
            n = bS5.nextSetBit(0);
        }
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, true, false);
        int n3 = n;
        while (true) {
            block13: {
                boolean bl4;
                float f4;
                Atom atom;
                boolean bl5;
                boolean bl6;
                block15: {
                    block12: {
                        block14: {
                            if (n3 < 0 || n3 >= this.atomCount) break block12;
                            bl6 = bl2 || bS.get(n3);
                            bl5 = bl2 || bS2.get(n3);
                            atom = this.atoms[n3];
                            if (atom.isDeleted()) break block13;
                            short s3 = atom.modelIndex;
                            if (s3 == s2) break block14;
                            s2 = s3;
                            if (!this.isJmolDataFrameForModel(s3)) break block14;
                            n3 = this.models[s3].firstAtomIndex + this.models[s3].atomCount - 1;
                            break block13;
                        }
                        if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) break block13;
                        bl4 = bS3 != null && bS3.get(n3);
                        float f5 = f4 + this.maxBondingRadius + f;
                        this.setIteratorForAtom(atomIndexIterator, -1, n3, f5, null);
                        break block15;
                    }
                    if (this.showRebondTimes) {
                        Logger.checkTimer("autoBond", false);
                    }
                    return n2;
                }
                while (atomIndexIterator.hasNext()) {
                    short s4;
                    boolean bl7;
                    Atom atom2 = this.atoms[atomIndexIterator.next()];
                    if (atom2.isDeleted()) continue;
                    int n4 = atom2.index;
                    boolean bl8 = bl2 || bS.get(n4);
                    boolean bl9 = bl7 = bl2 || bS2.get(n4);
                    if (!bl8 && !bl7 || (!bl6 || !bl7) && (!bl5 || !bl8) || bl4 && bS3.get(n4) || (s4 = ModelCollection.getBondOrderFull(f4, atom2.getBondingRadiusFloat(), atomIndexIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bS4)) continue;
                    ++n2;
                }
                atomIndexIterator.release();
            }
            n3 = bl2 ? n3 + 1 : bS5.nextSetBit(n3 + 1);
        }
    }

    private int autoBond_Pre_11_9_24(BS bS, BS bS2, BS bS3, BS bS4, short s) {
        if (this.atomCount == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getFloat(0x22000004);
        float f2 = this.viewer.getFloat(570425364);
        float f3 = f2 * f2;
        int n = 0;
        this.initializeBspf();
        short s2 = -1;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            float f4;
            Atom atom;
            boolean bl;
            boolean bl2 = bS == null || bS.get(n2);
            boolean bl3 = bl = bS2 == null || bS2.get(n2);
            if (!bl2 && !bl || (atom = this.atoms[n2]).isDeleted()) continue;
            short s3 = atom.modelIndex;
            if (s3 != s2) {
                s2 = s3;
                if (this.isJmolDataFrameForModel(s3)) {
                    while (--n2 >= 0 && this.atoms[n2].modelIndex == s3) {
                    }
                    ++n2;
                    continue;
                }
            }
            if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) continue;
            float f5 = f4 + this.maxBondingRadius + f;
            this.initializeBspt(s3);
            CubeIterator cubeIterator = this.bspf.getCubeIterator(s3);
            cubeIterator.initialize(atom, f5, true);
            while (cubeIterator.hasMoreElements()) {
                short s4;
                boolean bl4;
                Atom atom2 = (Atom)cubeIterator.nextElement();
                if (atom2 == atom || atom2.isDeleted()) continue;
                int n3 = atom2.index;
                boolean bl5 = bS == null || bS.get(n3);
                boolean bl6 = bl4 = bS2 == null || bS2.get(n3);
                if (!bl5 && !bl4 || bS3 != null && bS3.get(n3) && bS3.get(n2) || (!bl2 || !bl4) && (!bl || !bl5) || (s4 = ModelCollection.getBondOrderFull(f4, atom2.getBondingRadiusFloat(), cubeIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bS4)) continue;
                ++n;
            }
            cubeIterator.release();
        }
        return n;
    }

    private int[] autoBond(BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            BS bS4 = bS;
            bS = new BS();
            bS2 = new BS();
            int n = bS4.nextSetBit(0);
            while (n >= 0) {
                bS.set(this.bonds[n].atom1.index);
                bS2.set(this.bonds[n].atom2.index);
                n = bS4.nextSetBit(n + 1);
            }
        }
        return new int[]{bl2 ? this.autoHbond(bS, bS2, false) : this.autoBondBs4(bS, bS2, null, bS3, this.viewer.getMadBond(), bl3), 0};
    }

    public int autoHbond(BS bS, BS bS2, boolean bl) {
        int n;
        if (bl) {
            BS bS3 = this.getModelBitSet(bS, false);
            n = bS3.nextSetBit(0);
            while (n >= 0 && bl) {
                bl = !this.models[n].hasRasmolHBonds;
                n = bS3.nextSetBit(n + 1);
            }
            if (bl) {
                return 0;
            }
        }
        boolean bl2 = false;
        n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.atoms[n].getElementNumber() == 1) {
                bl2 = true;
                break;
            }
            n = bS.nextSetBit(n + 1);
        }
        BS bS4 = new BS();
        boolean bl3 = this.viewer.getBoolean(603979853);
        if (bS2 == null || bl3 && !bl2) {
            Logger.info((bS2 == null ? "DSSP " : "RasMol") + " pseudo-hbond calculation");
            this.calcRasmolHydrogenBonds(bS, bS2, null, false, Integer.MAX_VALUE, false, bS4);
            return -BSUtil.cardinalityOf(bS4);
        }
        Logger.info(bl2 ? "Standard Hbond calculation" : "Jmol pseudo-hbond calculation");
        BS bS5 = null;
        if (!bl2) {
            bS5 = new BS();
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                byte by = this.atoms[n2].atomID;
                switch (by) {
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 64: {
                        bS5.set(n2);
                    }
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        float f = this.viewer.getFloat(0x22000011);
        float f2 = (float)((double)this.viewer.getFloat(0x22000010) * Math.PI / 180.0);
        float f3 = f * f;
        float f4 = hbondMin * hbondMin;
        float f5 = 1.0f;
        float f6 = f > hbondMin ? f4 : f3;
        float f7 = f > hbondMin ? hbondMin : f;
        int n3 = 0;
        float f8 = 0.0f;
        V3 v3 = new V3();
        V3 v32 = new V3();
        if (this.showRebondTimes && Logger.debugging) {
            Logger.startTimer("hbond");
        }
        P3 p3 = null;
        P3 p32 = null;
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(bS2, false, false, false, false);
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            block19: {
                boolean bl4;
                float f9;
                float f10;
                float f11;
                short s;
                Object object;
                boolean bl5;
                Atom atom;
                block21: {
                    block20: {
                        atom = this.atoms[n4];
                        short s2 = atom.getElementNumber();
                        boolean bl6 = bl5 = s2 == 1;
                        if (!bl5 && (bl2 || s2 != 7 && s2 != 8) || bl5 && !bl2) break block19;
                        if (!bl5) break block20;
                        object = atom.bonds;
                        if (object == null) break block19;
                        s = 0;
                        for (int i = 0; i < ((Bond[])object).length && s == 0; ++i) {
                            Atom atom2 = object[i].getOtherAtom(atom);
                            short s3 = atom2.getElementNumber();
                            s = s3 == 7 || s3 == 8 ? (short)1 : 0;
                        }
                        if (s == 0) break block19;
                        f11 = f7;
                        f10 = f5;
                        f9 = f6;
                        bl4 = false;
                        break block21;
                    }
                    f11 = f;
                    f10 = f4;
                    f9 = f3;
                    bl4 = bS5.get(n4);
                }
                this.setIteratorForAtom(atomIndexIterator, -1, atom.index, f11, null);
                while (atomIndexIterator.hasNext()) {
                    int n5;
                    object = this.atoms[atomIndexIterator.next()];
                    s = ((Atom)object).getElementNumber();
                    if (object == atom || !bl5 && s != 7 && s != 8 || bl5 && s == 1 || (f8 = atomIndexIterator.foundDistance2()) < f10 || f8 > f9 || bl4 && bS5.get(((Atom)object).index) || atom.isBonded((Atom)object)) continue;
                    if (f2 > 0.0f) {
                        v3.sub2(atom, (Tuple3f)object);
                        p32 = ModelCollection.checkMinAttachedAngle(atom, f2, v3, v32, bl2);
                        if (p32 == null) continue;
                        v3.scale(-1.0f);
                        p3 = ModelCollection.checkMinAttachedAngle((Atom)object, f2, v3, v32, bl2);
                        if (p3 == null) continue;
                    }
                    float f12 = 0.0f;
                    if (bl5 && !Float.isNaN(p3.x) && !Float.isNaN(p32.x)) {
                        n5 = 4096;
                        f12 = (float)HBond.getEnergy((float)Math.sqrt(f8), p3.distance(atom), p3.distance(p32), ((P3)object).distance(p32)) / 1000.0f;
                    } else {
                        n5 = 2048;
                    }
                    bS4.set(this.addHBond(atom, (Atom)object, n5, f12));
                    ++n3;
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        this.shapeManager.setShapeSizeBs(1, Integer.MIN_VALUE, null, bS4);
        if (this.showRebondTimes) {
            Logger.checkTimer("hbond", false);
        }
        return bl2 ? n3 : -n3;
    }

    private static P3 checkMinAttachedAngle(Atom atom, float f, V3 v3, V3 v32, boolean bl) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || bondArray.length == 0) {
            return P3.new3(Float.NaN, 0.0f, 0.0f);
        }
        Atom atom2 = null;
        float f2 = Float.MAX_VALUE;
        int n = bondArray.length;
        while (--n >= 0) {
            if (!bondArray[n].isCovalent()) continue;
            Atom atom3 = bondArray[n].getOtherAtom(atom);
            if (!bl && atom3.getElementNumber() == 1) continue;
            v32.sub2(atom, atom3);
            float f3 = v32.angle(v3);
            if (f3 < f) {
                return null;
            }
            if (!(f3 < f2)) continue;
            atom2 = atom3;
            f2 = f3;
        }
        return atom2;
    }

    void setStructureIndexes() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            int n5;
            int n6 = this.atoms[i].modelIndex;
            n3 = n6;
            if (n6 != n4) {
                n = 0;
                n4 = n3;
                n2 = -1;
            }
            if ((n5 = this.atoms[i].getStrucNo()) == n2 || n5 == 0) continue;
            this.atoms[i].getGroup().setStrucNo(++n);
            n2 = n;
        }
    }

    public String getProteinStructureState(BS bS, boolean bl, boolean bl2, int n) {
        if (!this.isPDB) {
            return "";
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isBioModel) continue;
            return this.models[i].getProteinStructureState(bS, bl, bl2, n);
        }
        return "";
    }

    public String getModelInfoAsString() {
        SB sB = new SB().append("<models count=\"");
        sB.appendI(this.modelCount).append("\" modelSetHasVibrationVectors=\"").append(this.modelSetHasVibrationVectors() + "\">\n<properties>");
        if (this.modelSetProperties != null) {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                sB.append("\n <property name=\"").append(string).append("\" value=").append(Escape.eS(this.modelSetProperties.getProperty(string))).append(" />");
            }
            sB.append("\n</properties>");
        }
        for (int i = 0; i < this.modelCount; ++i) {
            sB.append("\n<model index=\"").appendI(i).append("\" n=\"").append(this.getModelNumberDotted(i)).append("\" id=").append(Escape.eS("" + this.getModelAuxiliaryInfoValue(i, "modelID")));
            int n = this.viewer.getJDXBaseModelIndex(i);
            if (n != i) {
                sB.append(" baseModelId=").append(Escape.eS((String)this.getModelAuxiliaryInfoValue(n, "jdxModelID")));
            }
            sB.append(" name=").append(Escape.eS(this.getModelName(i))).append(" title=").append(Escape.eS(this.getModelTitle(i))).append(" hasVibrationVectors=\"").appendB(this.modelHasVibrationVectors(i)).append("\" />");
        }
        sB.append("\n</models>");
        return sB.toString();
    }

    public String getSymmetryInfoAsString() {
        SB sB = new SB().append("Symmetry Information:");
        for (int i = 0; i < this.modelCount; ++i) {
            sB.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsStringForModel(i));
        }
        return sB.toString();
    }

    public BS getAtomsConnected(float f, float f2, int n, BS bS) {
        int n2;
        int n3;
        BS bS2 = new BS();
        int[] nArray = new int[this.atomCount];
        boolean bl = n == 30720;
        boolean bl2 = n == 65535;
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (!bl2 && !bond.is(n) && (!bl || !bond.isHydrogen())) continue;
            if (bS.get(bond.atom1.index)) {
                n2 = bond.atom2.index;
                nArray[n2] = nArray[n2] + 1;
                bS2.set(n2);
            }
            if (!bS.get(bond.atom2.index)) continue;
            n2 = bond.atom1.index;
            nArray[n2] = nArray[n2] + 1;
            bS2.set(n2);
        }
        n3 = f == 0.0f ? 1 : 0;
        n2 = this.atomCount;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bS2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bS2.set(n2);
        }
        return bS2;
    }

    public String getUnitCellInfoText() {
        int n = this.viewer.getCurrentModelIndex();
        if (n < 0) {
            return "no single current model";
        }
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "not applicable" : symmetryInterface.getUnitCellInfo();
    }

    public SymmetryInterface getSymTemp(boolean bl) {
        if (this.symTemp == null || bl) {
            this.symTemp = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symTemp;
    }

    public void createModels(int n) {
        int n2 = this.modelCount + n;
        Model[] modelArray = (Model[])ArrayUtil.arrayCopyObject(this.models, n2);
        this.validateBspf(false);
        this.modelNumbers = ArrayUtil.arrayCopyI(this.modelNumbers, n2);
        this.modelFileNumbers = ArrayUtil.arrayCopyI(this.modelFileNumbers, n2);
        this.modelNumbersForAtomLabel = ArrayUtil.arrayCopyS(this.modelNumbersForAtomLabel, n2);
        this.modelNames = ArrayUtil.arrayCopyS(this.modelNames, n2);
        this.frameTitles = ArrayUtil.arrayCopyS(this.frameTitles, n2);
        int n3 = this.getModelFileNumber(this.modelCount - 1) / 1000000 + 1;
        int n4 = 0;
        for (int i = this.modelCount; i < n2; ++i) {
            this.modelNumbers[i] = i + this.modelCount;
            this.modelFileNumbers[i] = n3 * 1000000 + ++n4;
            this.modelNumbersForAtomLabel[i] = this.modelNames[i] = n3 + "." + n4;
        }
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfoValue("group3Lists");
        if (stringArray != null) {
            int[][] nArray = (int[][])this.getModelSetAuxiliaryInfoValue("group3Counts");
            stringArray = ArrayUtil.arrayCopyS(stringArray, n2);
            nArray = ArrayUtil.arrayCopyII(nArray, n2);
            this.modelSetAuxiliaryInfo.put("group3Lists", stringArray);
            this.modelSetAuxiliaryInfo.put("group3Counts", nArray);
        }
        this.unitCells = (SymmetryInterface[])ArrayUtil.arrayCopyObject(this.unitCells, n2);
        for (n4 = this.modelCount; n4 < n2; ++n4) {
            modelArray[n4] = new Model((ModelSet)this, n4, -1, null, null, null);
            modelArray[n4].loadState = " model create #" + n4 + ";";
        }
        this.models = modelArray;
        this.modelCount = n2;
    }

    protected void deleteModel(int n, int n2, int n3, BS bS, BS bS2) {
        int n4;
        if (n < 0) {
            this.validateBspf(false);
            this.bsAll = null;
            this.resetMolecules();
            this.isBbcageDefault = false;
            this.calcBoundBoxDimensions(null, 1.0f);
            return;
        }
        this.modelNumbers = (int[])ArrayUtil.deleteElements(this.modelNumbers, n, 1);
        this.modelFileNumbers = (int[])ArrayUtil.deleteElements(this.modelFileNumbers, n, 1);
        this.modelNumbersForAtomLabel = (String[])ArrayUtil.deleteElements(this.modelNumbersForAtomLabel, n, 1);
        this.modelNames = (String[])ArrayUtil.deleteElements(this.modelNames, n, 1);
        this.frameTitles = (String[])ArrayUtil.deleteElements(this.frameTitles, n, 1);
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfoValue("group3Lists");
        int[][] nArray = (int[][])this.getModelSetAuxiliaryInfoValue("group3Counts");
        int n5 = n + 1;
        if (stringArray != null && stringArray[n5] != null) {
            n4 = stringArray[n5].length() / 6;
            while (--n4 >= 0) {
                if (nArray[n5][n4] <= 0) continue;
                int[] nArray2 = nArray[0];
                int n6 = n4;
                nArray2[n6] = nArray2[n6] - nArray[n5][n4];
                if (nArray[0][n4] != 0) continue;
                stringArray[0] = stringArray[0].substring(0, n4 * 6) + ",[" + stringArray[0].substring(n4 * 6 + 2);
            }
        }
        if (stringArray != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", ArrayUtil.deleteElements(stringArray, n, 1));
            this.modelSetAuxiliaryInfo.put("group3Counts", ArrayUtil.deleteElements(nArray, n, 1));
        }
        if (this.unitCells != null) {
            this.unitCells = (SymmetryInterface[])ArrayUtil.deleteElements(this.unitCells, n, 1);
        }
        n4 = this.stateScripts.size();
        while (--n4 >= 0) {
            if (((StateScript)this.stateScripts.get(n4)).deleteAtoms(n, bS2, bS)) continue;
            this.stateScripts.remove(n4);
        }
        this.deleteModelAtoms(n2, n3, bS);
        this.viewer.deleteModelAtoms(n2, n3, bS);
    }

    public String getMoInfo(int n) {
        SB sB = new SB();
        for (int i = 0; i < this.modelCount; ++i) {
            int n2;
            Map map;
            if (n >= 0 && i != n || (map = (Map)this.viewer.getModelAuxiliaryInfoValue(i, "moData")) == null) continue;
            JmolList jmolList = (JmolList)map.get("mos");
            int n3 = n2 = jmolList == null ? 0 : jmolList.size();
            if (n2 == 0) continue;
            int n4 = n2;
            while (--n4 >= 0) {
                String string;
                String string2;
                Float f;
                String string3;
                Map map2 = (Map)jmolList.get(n4);
                String string4 = (String)map2.get("type");
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = (String)map2.get("energyUnits")) == null) {
                    string3 = "";
                }
                if ((f = (Float)map2.get("occupancy")) != null) {
                    string4 = "occupancy " + f.floatValue() + " " + string4;
                }
                if ((string2 = (String)map2.get("symmetry")) != null) {
                    string4 = string4 + string2;
                }
                if (Float.isNaN(Parser.parseFloatStr(string = "" + map2.get("energy")))) {
                    sB.append(TextFormat.sprintf("model %-2s;  mo %-2i # %s\n", "sis", new Object[]{this.getModelNumberDotted(i), n4 + 1, string4}));
                    continue;
                }
                sB.append(TextFormat.sprintf("model %-2s;  mo %-2i # energy %-8.3f %s %s\n", "sifss", new Object[]{this.getModelNumberDotted(i), n4 + 1, map2.get("energy"), string3, string4}));
            }
        }
        return sB.toString();
    }

    public void assignAtom(int n, String string, boolean bl) {
        Object object;
        if (string == null) {
            string = "C";
        }
        Atom atom = this.atoms[n];
        BS bS = new BS();
        boolean bl2 = atom.getElementNumber() == 1;
        short s = Elements.elementNumberFromSymbol(string, true);
        boolean bl3 = false;
        if (s > 0) {
            this.setElement(atom, s);
            this.viewer.setShapeSizeRD(0, this.viewer.getDefaultRadiusData(), BSUtil.newAndSetBit(n));
            this.setAtomName(n, string + atom.getAtomNumber());
            if (!this.models[atom.modelIndex].isModelKit) {
                this.taintAtom(n, (byte)0);
            }
        } else if (string.equals("Pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (string.equals("Mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (string.equals("X")) {
            bl3 = true;
        } else if (!string.equals(".")) {
            return;
        }
        this.removeUnnecessaryBonds(atom, bl3);
        float f = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (bl2) {
                f = 1.5f;
            } else if (!bl2 && s == 1) {
                f = 1.0f;
            }
        }
        if (f != 0.0f) {
            object = V3.newV(atom);
            ((Tuple3f)object).sub(this.atoms[atom.getBondedAtomIndex(0)]);
            float f2 = ((V3)object).length();
            ((V3)object).normalize();
            ((Tuple3f)object).scale(f - f2);
            this.setAtomCoordRelative(n, ((V3)object).x, ((V3)object).y, ((V3)object).z);
        }
        object = BSUtil.newAndSetBit(n);
        if (s != 1 && bl) {
            this.validateBspf(false);
            bS = this.getAtomsWithinRD(1.0f, (BS)object, false, null);
            bS.andNot((BS)object);
            if (bS.nextSetBit(0) >= 0) {
                this.viewer.deleteAtoms(bS, false);
            }
            bS = this.viewer.getModelUndeletedAtomsBitSet(atom.modelIndex);
            bS.andNot(this.getAtomBitsMDa(1613758476, null));
            this.makeConnections2(0.1f, 1.8f, 1, 0x40000050, (BS)object, bS, null, false, false, 0.0f);
        }
        this.viewer.addHydrogens((BS)object, false, true);
    }

    public void deleteAtoms(BS bS) {
        if (bS == null) {
            return;
        }
        BS bS2 = new BS();
        int n = bS.nextSetBit(0);
        while (n >= 0 && n < this.atomCount) {
            this.atoms[n].delete(bS2);
            n = bS.nextSetBit(n + 1);
        }
        for (n = 0; n < this.modelCount; ++n) {
            this.models[n].bsAtomsDeleted.or(bS);
            this.models[n].bsAtomsDeleted.and(this.models[n].bsAtoms);
        }
        this.deleteBonds(bS2, false);
    }

    public String getModelCml(BS bS, int n, boolean bl) {
        Object object;
        Object object2;
        SB sB = new SB();
        int n2 = BSUtil.cardinalityOf(bS);
        if (n2 == 0) {
            return "";
        }
        XmlUtil.openTag(sB, "molecule");
        XmlUtil.openTag(sB, "atomArray");
        BS bS2 = new BS();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0 && --n >= 0) {
            object2 = this.atoms[n3];
            object = ((Atom)object2).getAtomName();
            TextFormat.simpleReplace((String)object, "\"", "''");
            bS2.set(((Atom)object2).index);
            XmlUtil.appendTag(sB, "atom/", new String[]{"id", "a" + (((Atom)object2).index + 1), "title", ((Atom)object2).getAtomName(), "elementType", ((Atom)object2).getElementSymbol(), "x3", "" + ((Atom)object2).x, "y3", "" + ((Atom)object2).y, "z3", "" + ((Atom)object2).z});
            n3 = bS.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(sB, "atomArray");
        if (bl) {
            XmlUtil.openTag(sB, "bondArray");
            for (n3 = 0; n3 < this.bondCount; ++n3) {
                String string;
                object2 = this.bonds[n3];
                object = ((Bond)object2).atom1;
                Atom atom = ((Bond)object2).atom2;
                if (!bS2.get(((Atom)object).index) || !bS2.get(atom.index) || (string = JmolEdge.getCmlBondOrder(((Bond)object2).order)) == null) continue;
                XmlUtil.appendTag(sB, "bond/", new String[]{"atomRefs2", "a" + (((Bond)object2).atom1.index + 1) + " a" + (((Bond)object2).atom2.index + 1), "order", string});
            }
            XmlUtil.closeTag(sB, "bondArray");
        }
        XmlUtil.closeTag(sB, "molecule");
        return sB.toString();
    }

    void adjustAtomArrays(int[] nArray, int n, int n2) {
        int n3;
        this.atomCount = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.atoms[n3] = this.atoms[nArray[n3]];
            this.atoms[n3].index = n3;
            Model model = this.models[this.atoms[n3].modelIndex];
            if (model.firstAtomIndex == nArray[n3]) {
                model.firstAtomIndex = n3;
            }
            model.bsAtoms.set(n3);
        }
        if (this.vibrationVectors != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.vibrationVectors[n3] = this.vibrationVectors[nArray[n3]];
            }
        }
        if (this.occupancies != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.occupancies[n3] = this.occupancies[nArray[n3]];
            }
        }
        if (this.bfactor100s != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.bfactor100s[n3] = this.bfactor100s[nArray[n3]];
            }
        }
        if (this.partialCharges != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.partialCharges[n3] = this.partialCharges[nArray[n3]];
            }
        }
        if (this.ellipsoids != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.ellipsoids[n3] = this.ellipsoids[nArray[n3]];
            }
        }
        if (this.atomNames != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomNames[n3] = this.atomNames[nArray[n3]];
            }
        }
        if (this.atomTypes != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomTypes[n3] = this.atomTypes[nArray[n3]];
            }
        }
        if (this.atomSerials != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomSerials[n3] = this.atomSerials[nArray[n3]];
            }
        }
    }

    protected void growAtomArrays(int n) {
        this.atoms = (Atom[])ArrayUtil.arrayCopyObject(this.atoms, n);
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (V3[])ArrayUtil.arrayCopyObject(this.vibrationVectors, n);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.arrayCopyByte(this.occupancies, n);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.arrayCopyShort(this.bfactor100s, n);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.arrayCopyF(this.partialCharges, n);
        }
        if (this.ellipsoids != null) {
            this.ellipsoids = (Quadric[][])ArrayUtil.arrayCopyObject(this.ellipsoids, n);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.arrayCopyS(this.atomNames, n);
        }
        if (this.atomTypes != null) {
            this.atomTypes = ArrayUtil.arrayCopyS(this.atomTypes, n);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.arrayCopyI(this.atomSerials, n);
        }
    }

    public Atom addAtom(int n, Group group, short s, String string, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n4, float f8, int n5, float f9, Quadric[] quadricArray, boolean bl, byte by, BS bS) {
        Atom atom = new Atom(n, this.atomCount, f, f2, f3, f4, bS, n3, s, n4, bl);
        ++this.models[n].atomCount;
        this.models[n].bsAtoms.set(this.atomCount);
        if (s % 128 == 1) {
            ++this.models[n].hydrogenCount;
        }
        if (this.atomCount >= this.atoms.length) {
            this.growAtomArrays(this.atomCount + 100);
        }
        this.atoms[this.atomCount] = atom;
        this.setBFactor(this.atomCount, f9);
        this.setOccupancy(this.atomCount, n5);
        this.setPartialCharge(this.atomCount, f8);
        if (quadricArray != null) {
            this.setEllipsoid(this.atomCount, quadricArray);
        }
        atom.group = group;
        atom.colixAtom = this.viewer.getColixAtomPalette(atom, EnumPalette.CPK.id);
        if (string != null) {
            int n6 = string.indexOf(0);
            if (n6 >= 0) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.atoms.length];
                }
                this.atomTypes[this.atomCount] = string.substring(n6 + 1);
                string = string.substring(0, n6);
            }
            atom.atomID = by;
            if (by == 0) {
                if (this.atomNames == null) {
                    this.atomNames = new String[this.atoms.length];
                }
                this.atomNames[this.atomCount] = string.intern();
            }
        }
        if (n2 != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.atoms.length];
            }
            this.atomSerials[this.atomCount] = n2;
        }
        if (!Float.isNaN(f5)) {
            this.setVibrationVector(this.atomCount, f5, f6, f7);
        }
        ++this.atomCount;
        return atom;
    }

    public String getInlineData(int n) {
        SB sB = null;
        if (n >= 0) {
            sB = this.models[n].loadScript;
        } else {
            n = this.modelCount;
            while (--n >= 0 && (sB = this.models[n].loadScript).length() <= 0) {
            }
        }
        int n2 = sB.lastIndexOf("data \"");
        if (n2 < 0) {
            return null;
        }
        n2 = sB.indexOf2("\"", n2 + 7);
        int n3 = sB.lastIndexOf("end \"");
        if (n3 < n2 || n2 < 0) {
            return null;
        }
        return sB.substring2(n2 + 2, n3);
    }

    public boolean isAtomPDB(int n) {
        return n >= 0 && this.models[this.atoms[n].modelIndex].isBioModel;
    }

    public boolean isAtomAssignable(int n) {
        return n >= 0 && this.atoms[n].modelIndex == this.modelCount - 1;
    }

    public int getGroupAtom(Atom atom, int n, String string) {
        Group group = atom.group;
        int n2 = group.getMonomerIndex();
        if (n2 < 0) {
            return -1;
        }
        Group[] groupArray = group.getGroups();
        int n3 = n2 + n;
        if (n3 >= 0 && n3 < groupArray.length) {
            Group group2 = groupArray[n3];
            if (n == 1 && !group2.isConnectedPrevious()) {
                return -1;
            }
            if ("0".equals(string)) {
                return group2.leadAtomIndex;
            }
            for (int i = group2.firstAtomIndex; i <= group2.lastAtomIndex; ++i) {
                if (string != null && !string.equalsIgnoreCase(this.atoms[i].getAtomName())) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean haveModelKit() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isModelKit) continue;
            return true;
        }
        return false;
    }

    public BS getModelKitStateBitset(BS bS, BS bS2) {
        BS bS3 = BSUtil.copy(bS2);
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.models[i].isModelKit) continue;
            bS3.andNot(this.models[i].bsAtoms);
        }
        return BSUtil.deleteBits(bS, bS3);
    }

    public void setAtomNamesAndNumbers(int n, int n2, AtomCollection atomCollection) {
        if (n2 < 0) {
            n = this.models[this.atoms[n].modelIndex].firstAtomIndex;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        boolean bl = this.isXYZ && this.viewer.getBoolean(603979978);
        int s = Integer.MAX_VALUE;
        int n3 = 1;
        for (int i = n; i < this.atomCount; ++i) {
            short s2;
            Atom atom = this.atoms[i];
            if (atom.modelIndex != s2) {
                s2 = atom.modelIndex;
                int n4 = n3 = bl ? 0 : 1;
            }
            if (this.atomSerials[i] == 0 || n2 < 0) {
                int n5 = this.atomSerials[i] = i < n2 ? atomCollection.atomSerials[i] : n3;
            }
            if (this.atomNames[i] == null || n2 < 0) {
                this.atomNames[i] = (atom.getElementSymbol() + this.atomSerials[i]).intern();
            }
            if (this.models[s2].isModelKit && (atom.getElementNumber() <= 0 || atom.isDeleted())) continue;
            ++n3;
        }
    }

    public void setUnitCellOffset(int n, P3 p3, int n2) {
        for (int i = n; i < this.modelCount; ++i) {
            SymmetryInterface symmetryInterface;
            if (i < 0 || n >= 0 && i != n && this.models[i].trajectoryBaseIndex != n || (symmetryInterface = this.getUnitCell(i)) == null) continue;
            if (p3 == null) {
                symmetryInterface.setOffset(n2);
                continue;
            }
            symmetryInterface.setOffsetPt(p3);
        }
    }

    public void connect(float[][] fArray) {
        this.resetMolecules();
        BS bS = new BS();
        for (int i = 0; i < fArray.length; ++i) {
            short s;
            int n;
            int n2;
            boolean bl;
            float[] fArray2 = fArray[i];
            if (fArray2 == null || fArray2.length < 2) continue;
            int n3 = (int)fArray2[0];
            boolean bl2 = bl = n3 < 0;
            if (bl) {
                n3 = -1 - n3;
            }
            if ((n2 = (int)fArray2[1]) < 0 || n3 >= this.atomCount || n2 >= this.atomCount) continue;
            int n4 = n = fArray2.length > 2 ? (int)fArray2[2] : 1;
            if (n < 0) {
                n &= 0xFFFF;
            }
            short s2 = s = fArray2.length > 3 ? (short)(1000.0f * fArray[i][3]) : this.getDefaultMadFromOrder(n);
            if (n == 0 || s == 0 && n != 32768 && !Bond.isOrderH(n)) {
                Bond bond = this.atoms[n3].getBond(this.atoms[n2]);
                if (bond == null) continue;
                bS.set(bond.index);
                continue;
            }
            float f = fArray2.length > 4 ? fArray2[4] : 0.0f;
            this.bondAtoms(this.atoms[n3], this.atoms[n2], n, s, null, f, bl, true);
        }
        if (bS.nextSetBit(0) >= 0) {
            this.deleteBonds(bS, false);
        }
    }

    public boolean allowSpecAtom() {
        return this.modelCount != 1 || this.models[0].isBioModel;
    }

    public void setFrameDelayMs(long l, BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.models[this.models[n].trajectoryBaseIndex].frameDelay = l;
            n = bS.nextSetBit(n + 1);
        }
    }

    public long getFrameDelayMs(int n) {
        return n < this.models.length && n >= 0 ? this.models[this.models[n].trajectoryBaseIndex].frameDelay : 0L;
    }

    public int getModelIndexFromId(String string) {
        boolean bl = string.indexOf("#") >= 0;
        boolean bl2 = string.toLowerCase().endsWith(".basemodel");
        if (bl2) {
            string = string.substring(0, string.length() - 10);
        }
        int n = -1;
        String string2 = null;
        for (int i = 0; i < this.modelCount; ++i) {
            String string3 = (String)this.getModelAuxiliaryInfoValue(i, "modelID");
            if (string3 == null && (string3 = this.getModelTitle(i)) == null) continue;
            if (bl) {
                string2 = this.getModelFileName(i) + "#";
                string3 = string2 + string3;
            }
            if (string.equalsIgnoreCase(string3)) {
                return bl2 ? this.viewer.getJDXBaseModelIndex(i) : i;
            }
            if (string2 == null || !string.startsWith(string2)) continue;
            n = -2;
        }
        return string2 == null && !bl ? -2 : n;
    }

    public Map<String, Object> getAuxiliaryInfo(BS bS) {
        Map<String, Object> map = this.modelSetAuxiliaryInfo;
        if (map == null) {
            return null;
        }
        JmolList<Map<String, Object>> jmolList = new JmolList<Map<String, Object>>();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bS != null && !bS.get(i)) continue;
            Map<String, Object> map2 = this.getModelAuxiliaryInfo(i);
            jmolList.addLast(map2);
        }
        map.put("models", jmolList);
        return map;
    }

    public static class StateScript {
        private int modelIndex;
        private BS bsBonds;
        private BS bsAtoms1;
        private BS bsAtoms2;
        private String script1;
        private String script2;
        public boolean inDefinedStateBlock;

        StateScript(int n, String string, BS bS, BS bS2, BS bS3, String string2, boolean bl) {
            this.modelIndex = n;
            this.script1 = string;
            this.bsBonds = BSUtil.copy(bS);
            this.bsAtoms1 = BSUtil.copy(bS2);
            this.bsAtoms2 = BSUtil.copy(bS3);
            this.script2 = string2;
            this.inDefinedStateBlock = bl;
        }

        public boolean isValid() {
            return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && this.bsBonds.nextSetBit(0) < 0 || this.bsAtoms1 != null && this.bsAtoms1.nextSetBit(0) < 0 || this.bsAtoms2 != null && this.bsAtoms2.nextSetBit(0) < 0);
        }

        public String toString() {
            String string;
            if (!this.isValid()) {
                return "";
            }
            SB sB = SB.newS(this.script1);
            if (this.bsBonds != null) {
                sB.append(" ").append(Escape.eBond(this.bsBonds));
            }
            if (this.bsAtoms1 != null) {
                sB.append(" ").append(Escape.eBS(this.bsAtoms1));
            }
            if (this.bsAtoms2 != null) {
                sB.append(" ").append(Escape.eBS(this.bsAtoms2));
            }
            if (this.script2 != null) {
                sB.append(" ").append(this.script2);
            }
            if (!(string = sB.toString()).endsWith(";")) {
                string = string + ";";
            }
            return string;
        }

        public boolean isConnect() {
            return this.script1.indexOf("connect") >= 0;
        }

        public boolean deleteAtoms(int n, BS bS, BS bS2) {
            if (n == this.modelIndex) {
                return false;
            }
            if (n > this.modelIndex) {
                return true;
            }
            BSUtil.deleteBits(this.bsBonds, bS);
            BSUtil.deleteBits(this.bsAtoms1, bS2);
            BSUtil.deleteBits(this.bsAtoms2, bS2);
            return this.isValid();
        }

        public void setModelIndex(int n) {
            this.modelIndex = n;
        }
    }
}

