/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Date;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumVdw;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.ContactPair;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

abstract class AtomDataReader
extends VolumeDataReader {
    protected float maxDistance;
    protected ContactPair contactPair;
    protected String fileName;
    protected String fileDotModel;
    protected int modelIndex;
    protected AtomData atomData = new AtomData();
    protected P3[] atomXyz;
    protected float[] atomRadius;
    protected float[] atomProp;
    protected int[] atomNo;
    protected int[] atomIndex;
    protected int[] myIndex;
    protected int atomCount;
    protected int myAtomCount;
    protected int nearbyAtomCount;
    protected int firstNearbyAtom;
    protected BS bsMySelected = new BS();
    protected BS bsMyIgnored = new BS();
    protected BS bsNearby;
    protected boolean doAddHydrogens;
    protected boolean havePlane;
    protected boolean doUseIterator;
    protected float theProperty;
    protected boolean haveOneProperty;
    private float minPtsPerAng;
    protected float[] thisPlane;
    protected BS thisAtomSet;
    protected int thisX;
    protected float margin;
    protected BS bsSurfaceVoxels;
    protected BS validSpheres;
    protected BS noFaceSpheres;
    protected int[] voxelSource;
    protected final P3 ptY0 = new P3();
    protected final P3 ptZ0 = new P3();
    protected final P3i pt0 = new P3i();
    protected final P3i pt1 = new P3i();
    protected final P3 ptXyzTemp = new P3();

    AtomDataReader() {
    }

    void init(SurfaceGenerator surfaceGenerator) {
        super.init(surfaceGenerator);
        this.precalculateVoxelData = true;
        this.atomDataServer = surfaceGenerator.getAtomDataServer();
    }

    protected void setup(boolean bl) {
        this.setup2();
    }

    protected void setup2() {
        this.contactPair = this.params.contactPair;
        this.doAddHydrogens = this.sg.getAtomDataServer() != null && this.params.addHydrogens;
        this.modelIndex = this.params.modelIndex;
        if (this.params.bsIgnore != null) {
            this.bsMyIgnored = this.params.bsIgnore;
        }
        if (this.params.volumeData != null) {
            this.setVolumeDataV(this.params.volumeData);
            this.setBBox(this.volumeData.volumetricOrigin, 0.0f);
            this.ptXyzTemp.setT(this.volumeData.volumetricOrigin);
            for (int i = 0; i < 3; ++i) {
                this.ptXyzTemp.scaleAdd2(this.volumeData.voxelCounts[i] - 1, this.volumeData.volumetricVectors[i], this.ptXyzTemp);
            }
            this.setBBox(this.ptXyzTemp, 0.0f);
        }
        boolean bl = this.havePlane = this.params.thePlane != null;
        if (this.havePlane) {
            this.volumeData.setPlaneParameters(this.params.thePlane);
        }
    }

    protected void markPlaneVoxels(P3 p3, float f) {
        int n = 0;
        int n2 = this.thisX * this.yzCount;
        int n3 = n2 + this.yzCount;
        while (n2 < n3) {
            this.volumeData.getPoint(n2, this.ptXyzTemp);
            this.thisPlane[n] = this.ptXyzTemp.distance(p3) - f;
            ++n2;
            ++n;
        }
    }

    protected void setVolumeForPlane() {
        if (this.useOriginStepsPoints) {
            this.xyzMin = P3.newP(this.params.origin);
            this.xyzMax = P3.newP(this.params.origin);
            this.xyzMax.x += (this.params.points.x - 1.0f) * this.params.steps.x;
            this.xyzMax.y += (this.params.points.y - 1.0f) * this.params.steps.y;
            this.xyzMax.z += (this.params.points.z - 1.0f) * this.params.steps.z;
        } else if (this.params.boundingBox == null) {
            this.getAtoms(this.params.bsSelected, false, true, false, false, false, false, this.params.mep_marginAngstroms);
            if (this.xyzMin == null) {
                this.xyzMin = P3.new3(-10.0f, -10.0f, -10.0f);
                this.xyzMax = P3.new3(10.0f, 10.0f, 10.0f);
            }
        } else {
            this.xyzMin = P3.newP(this.params.boundingBox[0]);
            this.xyzMax = P3.newP(this.params.boundingBox[1]);
        }
        this.setRanges(this.params.plane_ptsPerAngstrom, this.params.plane_gridMax, 0.0f);
    }

    protected void getAtoms(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, float f) {
        int n;
        if (bl5) {
            bl2 = true;
        }
        if (bl2) {
            if (this.params.atomRadiusData == null) {
                this.params.atomRadiusData = new RadiusData(null, 1.0f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
            }
            this.atomData.radiusData = this.params.atomRadiusData;
            this.atomData.radiusData.valueExtended = this.params.solventExtendedAtomRadius;
            if (bl) {
                this.atomData.radiusData.vdwType = EnumVdw.NOJMOL;
            }
        }
        this.atomData.modelIndex = this.modelIndex;
        this.atomData.bsSelected = bS;
        this.atomData.bsIgnored = this.bsMyIgnored;
        this.sg.fillAtomData(this.atomData, 1 | (bl4 ? 16 : 0) | (bl3 ? 4 : 0) | (bl2 ? 2 : 0));
        if (this.doUseIterator) {
            this.atomData.bsSelected = null;
        }
        this.atomCount = this.atomData.atomCount;
        this.modelIndex = this.atomData.firstModelIndex;
        int n2 = 0;
        boolean bl7 = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if ((bS == null || bS.get(i)) && !this.bsMyIgnored.get(i)) {
                if (this.havePlane) {
                    float f2;
                    this.atomData.atomRadius[i] = this.getWorkingRadius(i, f);
                    if (Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[i])) > 2.0f * f2) continue;
                }
                this.bsMySelected.set(i);
                ++n2;
                boolean bl8 = bl7 = !this.havePlane;
            }
            if (!bl2 || !bl5 && !bl7) continue;
            this.atomData.atomRadius[i] = this.getWorkingRadius(i, f);
        }
        float f3 = bl2 && bl ? this.getWorkingRadius(-1, f) : 0.0f;
        this.myAtomCount = BSUtil.cardinalityOf(this.bsMySelected);
        BS bS2 = BSUtil.copy(this.bsMySelected);
        int n3 = 0;
        this.atomProp = null;
        this.theProperty = Float.MAX_VALUE;
        this.haveOneProperty = false;
        float[] fArray = this.params.theProperty;
        if (this.myAtomCount > 0) {
            int n4;
            P3[] p3Array = null;
            if (bl) {
                this.atomData.bsSelected = bS2;
                this.atomDataServer.fillAtomData(this.atomData, 8);
                n3 = this.atomData.hydrogenAtomCount;
                p3Array = new P3[n3];
                for (n = 0; n < this.atomData.hAtoms.length; ++n) {
                    if (this.atomData.hAtoms[n] == null) continue;
                    n4 = this.atomData.hAtoms[n].length;
                    while (--n4 >= 0) {
                        p3Array[--n3] = this.atomData.hAtoms[n][n4];
                    }
                }
                n3 = p3Array.length;
                Logger.info(n3 + " attached hydrogens added");
            }
            n = n3 + this.myAtomCount;
            if (bl2) {
                this.atomRadius = new float[n];
            }
            this.atomXyz = new P3[n];
            if (this.params.theProperty != null) {
                this.atomProp = new float[n];
            }
            this.atomNo = new int[n];
            this.atomIndex = new int[n];
            this.myIndex = new int[this.atomCount];
            for (n4 = 0; n4 < n3; ++n4) {
                if (bl2) {
                    this.atomRadius[n4] = f3;
                }
                this.atomXyz[n4] = p3Array[n4];
                this.atomNo[n4] = -1;
                if (this.atomProp == null) continue;
                this.addAtomProp(n4, Float.NaN);
            }
            this.myAtomCount = n3;
            n4 = bS2.nextSetBit(0);
            while (n4 >= 0) {
                if (this.atomProp != null) {
                    this.addAtomProp(this.myAtomCount, fArray != null && n4 < fArray.length ? fArray[n4] : Float.NaN);
                }
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[n4];
                this.atomNo[this.myAtomCount] = this.atomData.atomicNumber[n4];
                this.atomIndex[this.myAtomCount] = n4;
                this.myIndex[n4] = this.myAtomCount;
                if (bl2) {
                    this.atomRadius[this.myAtomCount] = this.atomData.atomRadius[n4];
                }
                ++this.myAtomCount;
                n4 = bS2.nextSetBit(n4 + 1);
            }
        }
        this.firstNearbyAtom = this.myAtomCount;
        Logger.info(this.myAtomCount + " atoms will be used in the surface calculation");
        if (this.myAtomCount == 0) {
            this.setBBox(P3.new3(10.0f, 10.0f, 10.0f), 0.0f);
            this.setBBox(P3.new3(-10.0f, -10.0f, -10.0f), 0.0f);
        }
        for (int i = 0; i < this.myAtomCount; ++i) {
            this.setBBox(this.atomXyz[i], bl2 ? this.atomRadius[i] + 0.5f : 0.0f);
        }
        if (!Float.isNaN(this.params.scale)) {
            V3 v3 = V3.newV(this.xyzMax);
            v3.sub(this.xyzMin);
            v3.scale(0.5f);
            this.xyzMin.add(v3);
            v3.scale(this.params.scale);
            this.xyzMax.setT(this.xyzMin);
            this.xyzMax.add(v3);
            this.xyzMin.sub(v3);
        }
        if (!bl5 || this.myAtomCount == 0) {
            return;
        }
        P3 p3 = new P3();
        this.bsNearby = new BS();
        for (n = 0; n < this.atomCount; ++n) {
            if (bS2.get(n) || this.bsMyIgnored.get(n)) continue;
            float f4 = this.atomData.atomRadius[n];
            if (this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[n])) > 2.0f * f4) continue;
            if (this.params.theProperty != null) {
                f4 += this.maxDistance;
            }
            p3 = this.atomData.atomXyz[n];
            if (!(p3.x + f4 > this.xyzMin.x) || !(p3.x - f4 < this.xyzMax.x) || !(p3.y + f4 > this.xyzMin.y) || !(p3.y - f4 < this.xyzMax.y) || !(p3.z + f4 > this.xyzMin.z) || !(p3.z - f4 < this.xyzMax.z)) continue;
            this.bsNearby.set(n);
            ++this.nearbyAtomCount;
        }
        n = this.myAtomCount;
        if (this.nearbyAtomCount != 0) {
            this.atomRadius = ArrayUtil.arrayCopyF(this.atomRadius, n += this.nearbyAtomCount);
            this.atomXyz = (P3[])ArrayUtil.arrayCopyObject(this.atomXyz, n);
            if (this.atomIndex != null) {
                this.atomIndex = ArrayUtil.arrayCopyI(this.atomIndex, n);
            }
            if (fArray != null) {
                this.atomProp = ArrayUtil.arrayCopyF(this.atomProp, n);
            }
            int n5 = this.bsNearby.nextSetBit(0);
            while (n5 >= 0) {
                if (fArray != null) {
                    this.addAtomProp(this.myAtomCount, fArray[n5]);
                }
                this.myIndex[n5] = this.myAtomCount;
                this.atomIndex[this.myAtomCount] = n5;
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[n5];
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[n5];
                n5 = this.bsNearby.nextSetBit(n5 + 1);
            }
        }
        this.haveOneProperty = !Float.isNaN(this.theProperty);
        System.out.println("AtomDataR theProperty=" + this.theProperty);
    }

    private void addAtomProp(int n, float f) {
        this.atomProp[n] = f;
        if (!Float.isNaN(this.theProperty) && f != this.theProperty) {
            this.theProperty = this.theProperty == Float.MAX_VALUE ? f : Float.NaN;
        }
    }

    private float getWorkingRadius(int n, float f) {
        float f2 = n < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[n];
        return Float.isNaN(f) ? Math.max(f2, 0.1f) : f2 + f;
    }

    protected void setHeader(String string, String string2) {
        this.jvxlFileHeaderBuffer = new SB();
        if (this.atomData.programInfo != null) {
            this.jvxlFileHeaderBuffer.append("#created by ").append(this.atomData.programInfo).append(" on ").append("" + new Date()).append("\n");
        }
        this.jvxlFileHeaderBuffer.append(string).append("\n").append(string2).append("\n");
    }

    protected void setRanges(float f, int n, float f2) {
        if (this.xyzMin == null) {
            return;
        }
        this.ptsPerAngstrom = f;
        this.maxGrid = n;
        this.minPtsPerAng = f2;
        this.setVolumeData();
        JvxlCoder.jvxlCreateHeader(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    protected void setVolumeData() {
        if (!this.setVolumeDataParams()) {
            this.setVoxelRange(0, this.xyzMin.x, this.xyzMax.x, this.ptsPerAngstrom, this.maxGrid, this.minPtsPerAng);
            this.setVoxelRange(1, this.xyzMin.y, this.xyzMax.y, this.ptsPerAngstrom, this.maxGrid, this.minPtsPerAng);
            this.setVoxelRange(2, this.xyzMin.z, this.xyzMax.z, this.ptsPerAngstrom, this.maxGrid, this.minPtsPerAng);
        }
    }

    protected boolean fixTitleLine(int n) {
        if (this.params.title == null) {
            return false;
        }
        String string = this.params.title[n];
        if (string.indexOf("%F") > 0) {
            string = this.params.title[n] = TextFormat.formatStringS(string, "F", this.atomData.fileName);
        }
        if (string.indexOf("%M") > 0) {
            this.params.title[n] = TextFormat.formatStringS(string, "M", this.atomData.modelName);
        }
        return true;
    }

    protected void setVertexSource() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource = ArrayUtil.arrayCopyI(this.params.vertexSource, this.meshData.vertexCount);
            for (int i = 0; i < this.meshData.vertexCount; ++i) {
                this.params.vertexSource[i] = Math.abs(this.params.vertexSource[i]) - 1;
            }
        }
    }

    protected void resetPlane(float f) {
        for (int i = 0; i < this.yzCount; ++i) {
            this.thisPlane[i] = f;
        }
    }

    protected void resetVoxelData(float f) {
        for (int i = 0; i < this.nPointsX; ++i) {
            for (int j = 0; j < this.nPointsY; ++j) {
                for (int k = 0; k < this.nPointsZ; ++k) {
                    this.voxelData[i][j][k] = f;
                }
            }
        }
    }

    private float getVoxel(int n, int n2, int n3, int n4) {
        return this.isProgressive ? this.thisPlane[n4 % this.yzCount] : this.voxelData[n][n2][n3];
    }

    protected void unsetVoxelData() {
        this.unsetVoxelData2();
    }

    protected void unsetVoxelData2() {
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] != Float.MAX_VALUE) continue;
                this.thisPlane[i] = Float.NaN;
            }
        } else {
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        if (this.voxelData[i][j][k] != Float.MAX_VALUE) continue;
                        this.voxelData[i][j][k] = Float.NaN;
                    }
                }
            }
        }
    }

    protected void setGridLimitsForAtom(P3 p3, float f, P3i p3i, P3i p3i2) {
        this.volumeData.xyzToVoxelPt(p3.x, p3.y, p3.z, p3i);
        int n = (int)Math.floor((f += this.margin) / this.volumeData.volumetricVectorLengths[0]);
        int n2 = (int)Math.floor(f / this.volumeData.volumetricVectorLengths[1]);
        int n3 = (int)Math.floor(f / this.volumeData.volumetricVectorLengths[2]);
        p3i2.set(p3i.x + n, p3i.y + n2, p3i.z + n3);
        p3i.set(p3i.x - n, p3i.y - n2, p3i.z - n3);
        p3i.x = Math.max(p3i.x - 1, 0);
        p3i.y = Math.max(p3i.y - 1, 0);
        p3i.z = Math.max(p3i.z - 1, 0);
        p3i2.x = Math.min(p3i2.x + 1, this.nPointsX);
        p3i2.y = Math.min(p3i2.y + 1, this.nPointsY);
        p3i2.z = Math.min(p3i2.z + 1, this.nPointsZ);
    }

    protected void getAtomMinMax(BS bS, BS[] bSArray) {
        int n;
        for (n = 0; n < this.nPointsX; ++n) {
            bSArray[n] = new BS();
        }
        n = this.myAtomCount;
        while (--n >= 0) {
            if (bS != null && !bS.get(n)) continue;
            this.setGridLimitsForAtom(this.atomXyz[n], this.atomRadius[n], this.pt0, this.pt1);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                bSArray[i].set(n);
            }
        }
    }

    protected void markSphereVoxels(float f, float f2) {
        boolean bl = f2 != Float.MAX_VALUE && this.point != null;
        int n = this.thisAtomSet.nextSetBit(0);
        while (n >= 0) {
            if (this.havePlane || this.validSpheres == null || this.validSpheres.get(n)) {
                boolean bl2 = this.noFaceSpheres != null && this.noFaceSpheres.get(n);
                boolean bl3 = n >= this.firstNearbyAtom;
                P3 p3 = this.atomXyz[n];
                float f3 = this.atomRadius[n];
                if (!bl || !((double)p3.distance(this.point) > (double)(f2 + f3) + 0.5)) {
                    float f4 = f3 + f;
                    this.setGridLimitsForAtom(p3, f4, this.pt0, this.pt1);
                    if (this.isProgressive) {
                        this.pt0.x = this.thisX;
                        this.pt1.x = this.thisX + 1;
                    }
                    this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptXyzTemp);
                    for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                        this.ptY0.setT(this.ptXyzTemp);
                        for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                            this.ptZ0.setT(this.ptXyzTemp);
                            for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                                float f5 = this.ptXyzTemp.distance(p3) - f3;
                                int n2 = this.volumeData.getPointIndex(i, j, k);
                                if ((f == 0.0f || f5 <= f4) && f5 < this.getVoxel(i, j, k, n2)) {
                                    if (bl3 || bl && this.ptXyzTemp.distance(this.point) > f2) {
                                        f5 = Float.NaN;
                                    }
                                    this.setVoxel(i, j, k, n2, f5);
                                    if (!Float.isNaN(f5)) {
                                        if (this.voxelSource != null) {
                                            this.voxelSource[n2] = n + 1;
                                        }
                                        if (f5 < 0.0f && bl2) {
                                            this.bsSurfaceVoxels.set(n2);
                                        }
                                    }
                                }
                                this.ptXyzTemp.add(this.volumetricVectors[2]);
                            }
                            this.ptXyzTemp.scaleAdd2(1.0f, this.volumetricVectors[1], this.ptZ0);
                        }
                        this.ptXyzTemp.scaleAdd2(1.0f, this.volumetricVectors[0], this.ptY0);
                    }
                }
            }
            n = this.thisAtomSet.nextSetBit(n + 1);
        }
    }

    protected void setVoxel(int n, int n2, int n3, int n4, float f) {
        if (this.isProgressive) {
            this.thisPlane[n4 % this.yzCount] = f;
        } else {
            this.voxelData[n][n2][n3] = f;
        }
    }
}

