/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import org.jmol.api.ApiPlatform;
import org.jmol.util.ArrayUtil;

class JpegObj {
    String comment;
    private Object imageobj;
    int imageHeight;
    int imageWidth;
    int[] blockWidth;
    int[] blockHeight;
    int precision = 8;
    int numberOfComponents = 3;
    float[][][] components;
    int[] compID = new int[]{1, 2, 3};
    int[] hsampFactor = new int[]{1, 1, 1};
    int[] vsampFactor = new int[]{1, 1, 1};
    int[] qtableNumber = new int[]{0, 1, 1};
    int[] dctableNumber = new int[]{0, 1, 1};
    int[] actableNumber = new int[]{0, 1, 1};
    private boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    private boolean[] lastRowIsDummy = new boolean[]{false, false, false};
    int ss = 0;
    int se = 63;
    int ah = 0;
    int al = 0;
    private int[] compWidth;
    private int[] compHeight;
    private int maxHsampFactor;
    private int maxVsampFactor;

    public JpegObj(ApiPlatform apiPlatform, Object object, String string) {
        this.components = ArrayUtil.newFloat3(this.numberOfComponents, -1);
        this.compWidth = new int[this.numberOfComponents];
        this.compHeight = new int[this.numberOfComponents];
        this.blockWidth = new int[this.numberOfComponents];
        this.blockHeight = new int[this.numberOfComponents];
        this.imageobj = object;
        this.imageWidth = apiPlatform.getImageWidth(object);
        this.imageHeight = apiPlatform.getImageHeight(object);
        this.comment = string;
        this.getYCCArray(apiPlatform);
    }

    private void getYCCArray(ApiPlatform apiPlatform) {
        int n;
        this.maxHsampFactor = 1;
        this.maxVsampFactor = 1;
        for (n = 0; n < this.numberOfComponents; ++n) {
            this.maxHsampFactor = Math.max(this.maxHsampFactor, this.hsampFactor[n]);
            this.maxVsampFactor = Math.max(this.maxVsampFactor, this.vsampFactor[n]);
        }
        for (n = 0; n < this.numberOfComponents; ++n) {
            this.compWidth[n] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.maxHsampFactor * this.hsampFactor[n];
            if (this.compWidth[n] != this.imageWidth / this.maxHsampFactor * this.hsampFactor[n]) {
                this.lastColumnIsDummy[n] = true;
            }
            this.blockWidth[n] = (int)Math.ceil((double)this.compWidth[n] / 8.0);
            this.compHeight[n] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.maxVsampFactor * this.vsampFactor[n];
            if (this.compHeight[n] != this.imageHeight / this.maxVsampFactor * this.vsampFactor[n]) {
                this.lastRowIsDummy[n] = true;
            }
            this.blockHeight[n] = (int)Math.ceil((double)this.compHeight[n] / 8.0);
        }
        int[] nArray = new int[this.imageWidth * this.imageHeight];
        nArray = apiPlatform.grabPixels(this.imageobj, this.imageWidth, this.imageHeight, nArray, 0, this.imageHeight);
        float[][] fArray = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray2 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray3 = new float[this.compHeight[0]][this.compWidth[0]];
        int n2 = 0;
        for (n = 0; n < this.imageHeight; ++n) {
            for (int i = 0; i < this.imageWidth; ++i) {
                int n3 = nArray[n2] >> 16 & 0xFF;
                int n4 = nArray[n2] >> 8 & 0xFF;
                int n5 = nArray[n2] & 0xFF;
                fArray[n][i] = (float)(0.299 * (double)n3 + 0.587 * (double)n4 + 0.114 * (double)n5);
                fArray3[n][i] = 128.0f + (float)(-0.16874 * (double)n3 - 0.33126 * (double)n4 + 0.5 * (double)n5);
                fArray2[n][i] = 128.0f + (float)(0.5 * (double)n3 - 0.41869 * (double)n4 - 0.08131 * (double)n5);
                ++n2;
            }
        }
        this.components[0] = fArray;
        this.components[1] = fArray3;
        this.components[2] = fArray2;
    }
}

