/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.awt.Platform;
import org.jmol.console.GenericConsole;
import org.jmol.console.JmolButton;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.viewer.FileManager;

public abstract class JmolConsole
extends GenericConsole
implements ActionListener,
WindowListener {
    protected JFrame viewerFrame;
    protected Container externalContainer;
    protected ScriptEditor scriptEditor;

    public void dispose() {
        if (this.externalContainer instanceof Window) {
            ((Window)this.externalContainer).dispose();
        } else {
            this.externalContainer.setVisible(false);
        }
    }

    protected Container getPane() {
        return this.externalContainer instanceof JFrame ? ((JFrame)this.externalContainer).getContentPane() : this.externalContainer;
    }

    protected void setTitle() {
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setTitle(this.getLabel("title"));
        } else if (this.externalContainer instanceof JDialog) {
            ((JDialog)this.externalContainer).setTitle(this.getLabel("title"));
        }
    }

    public void setVisible(boolean bl) {
        this.externalContainer.setVisible(bl);
    }

    protected JmolAbstractButton setButton(String string) {
        return this.addButton(new JmolButton(this.getLabel(string)), string);
    }

    protected void updateLabels() {
        this.labels = null;
        boolean bl = GT.setDoTranslate(true);
        this.defaultMessage = this.getLabel("default");
        JmolConsole.setAbstractButtonLabels(this.menuMap, this.labels);
        this.setTitle();
        if (this.label1 != null) {
            this.label1.setText(this.getLabel("label1"));
        }
        GT.setDoTranslate(bl);
    }

    public JmolScriptEditorInterface getScriptEditor() {
        return this.scriptEditor == null ? (this.scriptEditor = new ScriptEditor(this.viewer, this.viewerFrame, this)) : this.scriptEditor;
    }

    protected String nextFileName(String string, int n) {
        Object object;
        String string2 = FileManager.getLocalPathForWritingFile(this.viewer, string);
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
        }
        if (string2.indexOf("/") >= 0) {
            if (string3.equals(string2)) {
                string = "";
            } else {
                object = new File(string2);
                string2 = ((File)object).getParent();
                string = ((File)object).getName();
            }
        }
        object = new FileChecker(string);
        try {
            new File(string2).list((FilenameFilter)object);
            return string3 + ((FileChecker)object).getFile(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doAction(actionEvent.getSource());
    }

    protected boolean isMenuItem(Object object) {
        return object instanceof JMenuItem;
    }

    protected void addWindowListener() {
        Window window = Platform.getWindow(this.externalContainer);
        if (window != null) {
            window.addWindowListener(this);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private class FileChecker
    implements FilenameFilter {
        private String stub;
        private JmolList<String> v = new JmolList();

        protected FileChecker(String string) {
            this.stub = string.toLowerCase();
        }

        public boolean accept(File file, String string) {
            if (!string.toLowerCase().startsWith(this.stub)) {
                return false;
            }
            this.v.addLast(string);
            return true;
        }

        protected String getFile(int n) {
            return ArrayUtil.sortedItem(this.v, n);
        }
    }
}

