/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Node;
import org.jmol.util.P3;

public class CubeIterator {
    private Bspt bspt;
    private Element[] stack;
    private int sp;
    private int leafIndex;
    private Leaf leaf;
    private float radius;
    private float cx;
    private float cy;
    private float cz;
    private float dx;
    private float dy;
    private float dz;
    private boolean tHemisphere;

    CubeIterator(Bspt bspt) {
        this.set(bspt);
    }

    void set(Bspt bspt) {
        this.bspt = bspt;
        this.stack = new Element[bspt.treeDepth];
    }

    public void initialize(P3 p3, float f, boolean bl) {
        this.radius = f;
        this.tHemisphere = false;
        this.cx = p3.x;
        this.cy = p3.y;
        this.cz = p3.z;
        this.leaf = null;
        this.stack[0] = this.bspt.eleRoot;
        this.sp = 1;
        this.findLeftLeaf();
        this.tHemisphere = bl;
    }

    public void release() {
        this.set(this.bspt);
    }

    public boolean hasMoreElements() {
        while (this.leaf != null) {
            while (this.leafIndex < this.leaf.count) {
                if (this.isWithinRadius(this.leaf.tuples[this.leafIndex])) {
                    return true;
                }
                ++this.leafIndex;
            }
            this.findLeftLeaf();
        }
        return false;
    }

    public P3 nextElement() {
        return this.leaf.tuples[this.leafIndex++];
    }

    public float foundDistance2() {
        return this.dx * this.dx + this.dy * this.dy + this.dz * this.dz;
    }

    private void findLeftLeaf() {
        this.leaf = null;
        if (this.sp == 0) {
            return;
        }
        Element element = this.stack[--this.sp];
        while (element instanceof Node) {
            float f;
            Node node = (Node)element;
            switch (node.dim) {
                case 0: {
                    f = this.cx;
                    break;
                }
                case 1: {
                    f = this.cy;
                    break;
                }
                default: {
                    f = this.cz;
                }
            }
            float f2 = f + this.radius;
            if (!this.tHemisphere || node.dim != 0) {
                f -= this.radius;
            }
            if (f <= node.maxLeft && f2 >= node.minLeft) {
                if (f2 >= node.minRight && f <= node.maxRight) {
                    this.stack[this.sp++] = node.eleRight;
                }
                element = node.eleLeft;
                continue;
            }
            if (f2 >= node.minRight && f <= node.maxRight) {
                element = node.eleRight;
                continue;
            }
            if (this.sp == 0) {
                return;
            }
            element = this.stack[--this.sp];
        }
        this.leaf = (Leaf)element;
        this.leafIndex = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWithinRadius(P3 p3) {
        float f;
        float f2;
        float f3;
        this.dx = p3.x - this.cx;
        if (this.tHemisphere) {
            if (!(this.dx >= 0.0f)) return false;
        }
        this.dx = Math.abs(this.dx);
        if (!(f3 <= this.radius)) return false;
        this.dy = Math.abs(p3.y - this.cy);
        if (!(f2 <= this.radius)) return false;
        this.dz = Math.abs(p3.z - this.cz);
        if (!(f <= this.radius)) return false;
        return true;
    }
}

