/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.P3;

public class AmpacReader
extends AtomSetCollectionReader {
    private int atomCount;
    private int freqAtom0 = -1;
    private float[] partialCharges;
    private P3[] atomPositions;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("CARTESIAN COORDINATES") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("NET ATOMIC CHARGES") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] stringArray;
        boolean bl;
        boolean bl2 = bl = this.freqAtom0 >= 0;
        if (bl) {
            this.atomPositions = new P3[this.atomCount];
        } else {
            this.atomSetCollection.newAtomSet();
        }
        this.readLine();
        this.atomCount = 0;
        while (this.readLine() != null && (stringArray = this.getTokens()).length >= 5) {
            if (bl) {
                this.atomPositions[this.atomCount] = P3.new3(this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]));
            } else {
                String string = stringArray[1];
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.elementSymbol = string;
                this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]));
            }
            ++this.atomCount;
        }
        if (bl) {
            this.setPositions();
        }
    }

    private void setPositions() {
        int n = this.atomSetCollection.getAtomCount();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = this.freqAtom0; i < n; ++i) {
            atomArray[i].setT(this.atomPositions[i % this.atomCount]);
            atomArray[i].partialCharge = this.partialCharges[i % this.atomCount];
        }
    }

    private void readPartialCharges() throws Exception {
        String[] stringArray;
        this.readLine();
        this.partialCharges = new float[this.atomCount];
        for (int i = 0; i < this.atomCount && this.readLine() != null && (stringArray = this.getTokens()).length >= 4; ++i) {
            this.partialCharges[i] = this.parseFloatStr(stringArray[2]);
        }
    }

    private void readFrequencies() throws Exception {
        while (this.readLine() != null && this.line.indexOf("FREQ  :") < 0) {
        }
        while (this.line != null && this.line.indexOf("FREQ  :") >= 0) {
            String[] stringArray = this.getTokens();
            while (this.readLine() != null && this.line.indexOf("IR I") < 0) {
            }
            int n = this.atomSetCollection.getAtomCount();
            if (this.vibrationNumber == 0) {
                this.freqAtom0 = n;
            }
            int n2 = stringArray.length - 2;
            boolean[] blArray = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(stringArray[i + 2] + " cm^-1");
                this.atomSetCollection.setAtomSetModelProperty("Frequency", stringArray[i + 2] + " cm^-1");
                this.atomSetCollection.setAtomSetModelProperty(".PATH", "Frequencies");
            }
            this.fillFrequencyData(n, this.atomCount, this.atomCount, blArray, false, 8, 9, null, 0);
            this.readLine();
            this.readLine();
        }
    }
}

